% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridfs.R
\name{gridfs}
\alias{gridfs}
\title{GridFS API}
\usage{
gridfs(db = "test", url = "mongodb://localhost", prefix = "fs",
  options = ssl_options())
}
\arguments{
\item{db}{name of database}

\item{url}{address of the mongodb server in mongo connection string
\href{http://docs.mongodb.org/manual/reference/connection-string}{URI format}}

\item{prefix}{string to prefix the collection name}

\item{options}{additional connection options such as SSL keys/certs.}
}
\description{
Connect to a GridFS database.
}
\examples{
# New GridFS
\donttest{
fs <- gridfs(url = "mongodb+srv://readwrite:test@cluster0-84vdt.mongodb.net/test")
input <- R.home('doc/NEWS.pdf')
fs$upload(input)
fs$download('NEWS.pdf', 'output.pdf')
hashes <- tools::md5sum(c(input, 'output.pdf'))
unlink('output.pdf')
stopifnot(hashes[[1]] == hashes[[1]])

# Insert Binary Data
fs$write('iris3', serialize(datasets::iris3, NULL))
out <- fs$read('iris3')
iris4 <- unserialize(out$data)
stopifnot(all.equal(iris4, datasets::iris3))

# Show what we have
fs$find()
fs$drop()
}
}
