% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-s3.R
\name{predict.morf}
\alias{predict.morf}
\title{Prediction Method for morf Objects}
\usage{
\method{predict}{morf}(object, data = NULL, type = "response", ...)
}
\arguments{
\item{object}{An \code{\link{morf}} object.}

\item{data}{Data set of class \code{data.frame}. It must contain at least the same covariates used to train the forests. If \code{data} is \code{NULL}, then \code{object$full_data} is used.}

\item{type}{Type of prediction. Either \code{"response"} or \code{"terminalNodes"}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Desired predictions.
}
\description{
Prediction method for class \code{\link{morf}}.
}
\details{
If \code{type == "response"}, the routine returns the predicted conditional class probabilities and the predicted class 
labels. If forests are honest, the predicted probabilities are honest.\cr

If \code{type == "terminalNodes"}, the IDs of the terminal node in each tree for each observation in \code{data} are returned.\cr
}
\examples{
## Load data from orf package.
set.seed(1986)

library(orf)
data(odata)
odata <- odata[1:200, ] # Subset to reduce elapsed time.

y <- as.numeric(odata[, 1])
X <- as.matrix(odata[, -1])

## Training-test split.
train_idx <- sample(seq_len(length(y)), floor(length(y) * 0.5))

y_tr <- y[train_idx]
X_tr <- X[train_idx, ]

y_test <- y[-train_idx]
X_test <- X[-train_idx, ]

## Fit morf on training sample.
forests <- morf(y_tr, X_tr)

## Predict on test sample.
predictions <- predict(forests, X_test)
head(predictions$probabilities)
predictions$classification

## Get terminal nodes.
predictions <- predict(forests, X_test, type = "terminalNodes")
predictions$forest.1[1:10, 1:20] # Rows are observations, columns are forests.

}
\seealso{
\code{\link{morf}}, \code{\link{marginal_effects}}
}
\author{
Riccardo Di Francesco
}
