% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_Nsurv.R
\name{predict_Nsurv.survFit}
\alias{predict_Nsurv.survFit}
\title{\code{Predict_Nsurv} method for \code{survFit} objects}
\usage{
\method{predict_Nsurv}{survFit}(object, data_predict = NULL,
  spaghetti = FALSE, mcmc_size = NULL, hb_value = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{survFit}}

\item{data_predict}{A dataframe with three columns \code{time}, \code{conc}, \code{replicate},
and \code{Nsurv}  used for prediction. If \code{NULL}, prediction is based on \code{x} object of 
 class \code{survFit} used for fitting.}

\item{spaghetti}{If \code{TRUE}, return a set of survival curves using
parameters drawn from the posterior distribution.}

\item{mcmc_size}{Can be used to reduce the number of mcmc samples in order to speed up
the computation.}

\item{hb_value}{If \code{TRUE}, the background mortality \code{hb} is taken into account from the posterior.
If \code{FALSE}, parameter \code{hb} is set to 0. The default is \code{TRUE}.}

\item{\dots}{Further arguments to be passed to generic methods}
}
\value{
The function returns an object of class \code{survFitPredict_Nsurv}, which is
a list with the two following \code{data.frame}:
\item{df_quantile}{A \code{data.frame} with 10 columns, \code{time}, \code{conc}, \code{replicate},
\code{Nsurv} (observed number of survivors) and other columns with median and 95\% credible interval
of the number of survivors computed with 2 different way refers as \code{check} and \code{valid} 
\code{Nsurv_q50_check}, \code{Nsurv_qinf95_check},
\code{Nsurv_qsup95_check}, \code{Nsurv_q50_valid}, \code{Nsurv_qinf95_valid},
\code{Nsurv_qsup95_valid}. \code{_check} means the number of survivor at time \eqn{t} is estimated using the observed number
of survivor at time \eqn{t-1}, while \code{_valid} means the number of survivor estimated at time
\eqn{t} is based on the estimated number of survivor at time \eqn{t-1}.}
\item{df_spaghetti}{NULL if arguement \code{spaghetti = FALSE}. With \code{spaghetti = TRUE}, it returns a
dataframe with all simulation based on MCMC parameters return from a \code{survFit} object.}
}
\description{
It provides simulation for "SD" or "IT" models under constant or
time-variable exposure.
}
\examples{

# (1) Load the survival data
data("propiconazole_pulse_exposure")

# (2) Create an object of class "survData"
dataset <- survData(propiconazole_pulse_exposure)

\dontrun{
# (3) Run the survFit function
out <- survFit(dataset , model_type = "SD")

# (4) Create a new data table for prediction
data_4prediction <- data.frame(time = 1:10,
                               conc = c(0,5,30,30,0,0,5,30,15,0),
                               replicate= rep("predict", 10),
                               Nsurv = c(20,20,17,16,15,15,15,14,13,12))

# (5) Predict Nsurv on a new dataset
predict_out <- predict_Nsurv(object = out, data_predict = data_4prediction, spaghetti = TRUE)

}


}
