% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piecewiseStationary.R
\name{piecewiseStationary_signal}
\alias{piecewiseStationary_signal}
\title{Piecewise stationary model time series signal}
\usage{
piecewiseStationary_signal(model = c("custom", "blocks", "fms", "mix",
  "stairs10", "teeth10")[1], lengths = NULL, means = NULL, sds = NULL)
}
\arguments{
\item{model}{A string indicating which model to be returned; 
possible values are "blocks", "fms", "mix", "stairs10", "teeth10"
(for the referenced model signals) or "custom" (for user specification 
in terms of \code{lengths}, \code{means} and \code{sds});}

\item{lengths}{(use iff model="custom"): integer vector for the lengths of the piecewise stationary parts;}

\item{means}{(use iff model="custom"): numeric vector for the means of the piecewise stationary parts;}

\item{sds}{(use iff model="custom"): numeric vector for the deviation scaling of the piecewise stationary parts.
The values are multiplied with the outcome of \code{rand.gen}. Note that it corresponds to the standard
deviation in case of standard normal innovations (\code{rand.gen=rnorm});}
}
\value{
a list containing the following entries:
  \item{mu_t}{mean vector of piecewise stationary model time series}
  \item{sigma_t}{deviation scaling vector of piecewise stationary model time series}
}
\description{
Get mean and sd vector of piecewise stationary time series
}
\details{
See Appendix B in the first reference for details about the model time series.
}
\references{
P. Fryzlewicz.
\emph{Wild Binary Segmentation for Multiple Change-Point Detection.}
The Annals of Statistics, Vol. 42, No. 6, 2243-2281, 2014.

A. Meier, C. Kirch and H. Cho.
\emph{mosum: A Package for Moving Sums in Change Point Analysis.}
Unpublished manuscript, 2018+.
}
