% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-db.R
\name{create_database}
\alias{create_database}
\title{Create (If Not Exists) and Switch to a Database}
\usage{
create_database(.con, database_name)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}

\item{database_name}{Name of the database to create/ensure and switch to}
}
\value{
Invisibly returns \code{NULL}.
Side effect: may create a database and switches to it; prints CLI status
}
\description{
Ensures a database exists and sets it as the active database.
If connected to MotherDuck, the function will run
\verb{CREATE DATABASE IF NOT EXISTS} followed by \verb{USE <database>}.
Prints CLI status information about the current user and database.
}
\details{
\itemize{
\item Connection type is checked via \code{validate_md_connection_status()}
(with \code{return_type = "arg"}).
\item On MotherDuck, executes:
\itemize{
\item \verb{CREATE DATABASE IF NOT EXISTS <database>}
\item \verb{USE <database>}
}
\item Displays status and environment info with CLI messages.
}
}
\examples{
\dontrun{
con_md <- connect_to_motherduck()
create_database(con_md, "analytics")
}

}
\seealso{
Other db-manage: 
\code{\link{alter_table_schema}()},
\code{\link{copy_tables_to_new_location}()},
\code{\link{create_if_not_exists_share}()},
\code{\link{create_or_replace_share}()},
\code{\link{create_schema}()},
\code{\link{create_table}()},
\code{\link{delete_and_create_schema}()},
\code{\link{delete_database}()},
\code{\link{delete_schema}()},
\code{\link{delete_table}()},
\code{\link{describe_share}()},
\code{\link{drop_share}()},
\code{\link{list_owned_shares}()},
\code{\link{list_shared_with_me_shares}()},
\code{\link{upload_database_to_md}()}
}
\concept{db-manage}
