% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-md.R
\name{summary}
\alias{summary}
\alias{summary.tbl_lazy}
\title{Summarize a Lazy DBI Table}
\usage{
\method{summary}{tbl_lazy}(object, ...)
}
\arguments{
\item{object}{A \code{\link[dbplyr:tbl_lazy]{tbl_lazy}} object representing a remote
database table or query.}

\item{...}{Additional arguments (currently unused). Present for S3 method
compatibility.}
}
\value{
A \code{\link[dbplyr:tbl_lazy]{tbl_lazy}} object containing the summarized results,
still backed by the remote database connection.
}
\description{
The \code{summary.tbl_lazy()} method provides a database-aware summary interface
for lazy tables created via \strong{dbplyr}. Instead of collecting data into R,
it constructs a SQL \code{SUMMARIZE} query and executes it remotely, returning
another lazy table reference.
}
\details{
This method does \strong{not} pull data into memory. Instead, it creates a new
lazy query object representing the database-side summary. To retrieve the
summarized data, use \code{collect()} on the returned object.
}
\examples{
\dontrun{
library(DBI)
library(duckdb)
library(dplyr)

con <- dbConnect(duckdb::duckdb(dbdir = tempfile()))
dbWriteTable(con, "mtcars", mtcars)

tbl_obj <- tbl(con, "mtcars")

# Returns a lazy summary table
summary(tbl_obj)

dbDisconnect(con)
}


}
