% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropTipPartial.R
\name{dropTipPartial}
\alias{dropTipPartial}
\title{Drop tips from a phylogenetic tree while preserving deleted nodes}
\usage{
dropTipPartial(phy, tip)
}
\arguments{
\item{phy}{Phylogenetic tree in \code{phylo} format}

\item{tip}{A vector of mode numeric or character specifying the tips to delete, to be passed to \code{drop.tip}}
}
\value{
Phylogenetic tree in \code{phylo} format, with an added element \code{Shid}, a vector of numbers of observed but "missing" speciation events per branch, in the same order as the branches in the \code{phylo} object
}
\description{
Wrapper for the \code{ape} function \code{drop.tip} that preserves the number of nodes affecting each branch. For use with the \code{psi} and \code{multipsi} models.
}
\examples{
## Read in phylogeny and data from Thomas et al. (2009)
data(anolis.tree)
data(anolis.data)
## identify tips to drop
tips.to.go <- anolis.tree$tip.label[1:30]
dropTipPartial(phy=anolis.tree, tip=tips.to.go)
}
\references{
Ingram, T. 2011. Speciation along a depth gradient in a marine adaptive radiation. Proc. R. Soc. B 278: 613-618.
}
\seealso{
\code{\link{transformPhylo.ML}}
}
\author{
Travis Ingram
}
