% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.timeSlice.ML.R
\name{plot.timeSlice.ML}
\alias{plot.timeSlice.ML}
\title{Identify shifts in the rate of trait diversification through time}
\usage{
\method{plot}{timeSlice.ML}(
  x,
  ...,
  cutoff = 4,
  AICc = TRUE,
  lowerBound = 1e-08,
  upperBound = 1000,
  phylo.plot = TRUE,
  colour.ramp = c("blue", "red"),
  cex.plot = 1,
  model.average = FALSE
)
}
\arguments{
\item{x}{Output of a timeSlice analysis in \code{\link{transformPhylo.ML}}}

\item{...}{Other functions to pass to \code{\link[ape]{plot.phylo}}}

\item{cutoff}{Value for differences in AIC scores when comparing models. More complex models with an AIC score more than this number of units lower than simpler models are retained (as per runMedusa in the geiger package).}

\item{AICc}{If \code{TRUE}, AICc is used instead of AIC.}

\item{lowerBound}{Minimum value for parameter estimates.}

\item{upperBound}{Maximum value for parameter estimates.}

\item{phylo.plot}{Logical. If \code{TRUE}, the phylogeny is plotted}

\item{colour.ramp}{The colours signifying different rates from low (first colour) to high (second colour)}

\item{cex.plot}{Character expansion for the plot of rates through time}

\item{model.average}{Logical only applicable to "timeSlice" models. Will return the model averaged timeSlice for models in which multiple shifts were considered (i.e, when splitTime is NULL). If TRUE, the function returns a plot showing the relative weights of each shift time and the model-averaged rates through time that are weighted by their relative weights. If TRUE, plot.phylo is ignored.}
}
\value{
ModelFit Summary of the best optimal rate shift model or the model average of each split time (if model averaging was used).

Rates Summary of the rate parameters from the best rate shift model or the model averaged rates through time.

optimalTree A phylo object with branch lengths scaled relative to rate and a plot of estimated rates through time with their associated CIs.
}
\description{
Summarises phenotypic rate variation on phylogenies through
}
\details{
This functions summarises the output of a "timeSlice" model in \code{\link{transformPhylo.ML}} (see below). The best overall model is chosen based on AIC (or AICc if AICc=TRUE). The cut-off point for improvement in AIC score between successively more complex models can be defined using cutoff. The default cutoff is 4 but this is somewhat arbitrary and a "good" cut-off may well vary between data sets so it may well be worth exploring different cutoffs.
}
\examples{
data(anolis.tree)
data(anolis.data)
attach(anolis.data)
male.length <- matrix(Male_SVL, dimnames=list(rownames(anolis.data)))
sortedData <- sortTraitData(anolis.tree, male.length)
phy <- sortedData$phy
male.length <- sortedData$trait
phy.clade <- extract.clade(phy, 182)
male.length.clade <- as.matrix(male.length[match(phy.clade$tip.label, 
rownames(male.length)),])
timeSlice.10.ml <- transformPhylo.ML(y=male.length.clade, phy=phy.clade, model="timeSlice", 
splitTime=c(10))
outputSummary <- plot(timeSlice.10.ml, cutoff=0.001, cex=0.5, 
colour.ramp=c("blue", "red"))
}
\references{
To Add
}
\seealso{
\code{\link{transformPhylo.ML}}
}
\author{
Mark Puttick
}
