% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{mt_plot_per_trajectory}
\alias{mt_plot_per_trajectory}
\title{Create pdf with separate plots per trajectory.}
\usage{
mt_plot_per_trajectory(file, data, use = "trajectories", x = "xpos",
  y = "ypos", show_progress = TRUE, ...)
}
\arguments{
\item{file}{a character string specifying the name of the pdf file. Passed on
to \link{pdf}.}

\item{data}{a mousetrap data object created using one of the mt_import 
functions (e.g., \link{mt_import_mousetrap}).}

\item{use}{a character string specifying which trajectories should be 
plotted. The corresponding trajectories are selected from data using 
\code{data[[use]]}. Usually, this value corresponds to either 
"trajectories", "tn_trajectories" or "av_trajectories", depending on 
whether the raw, time-normalized or averaged trajectories should be 
plotted.}

\item{x}{a character string specifying which dimension in the trajectory 
array should be displayed on the x-axis (defaults to xpos).}

\item{y}{a character string specifying which dimension in the trajectory 
array should be displayed on the y-axis (defaults to ypos).}

\item{show_progress}{logical indicating whether function should report its 
progress.}

\item{...}{additional arguments passed on to \link{pdf}.}
}
\description{
\code{mt_plot_per_trajectory} creates a PDF file with separate plots per 
trajectory. This PDF can be used for inspecting individual trajectories. Note
that plotting all trajectories can be time-consuming, especially for raw 
trajectories. If the appropriate \code{x} and \code{y} arguments are
inserted, this function can also be used for plotting velocity and
acceleration profiles.
}
\details{
\code{mt_plot_per_trajectory} creates a pdf using \link{pdf}. Next, it plots 
all trajectories individually using \link{mt_plot}. Every plot is labeled 
using the \link{mt_id} variable.
}
\examples{
\dontrun{
mt_plot_per_trajectory(mt_example,
  file="trajectories.pdf",
  use="trajectories")
}

}
\seealso{
\link{mt_plot} for plotting trajectory data.
}

