% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database.R
\name{get_nrows}
\alias{get_nrows}
\title{Get the number of rows sensors in a mpathsenser database}
\usage{
get_nrows(
  db,
  sensor = "All",
  participant_id = NULL,
  start_date = NULL,
  end_date = NULL
)
}
\arguments{
\item{db}{db A database connection, as created by \link[mpathsenser]{create_db}.}

\item{sensor}{A character vector of one or multiple vectors. Use "All" for all sensors. See
\link[mpathsenser]{sensors} for a list of all available sensors.}

\item{participant_id}{A character string identifying a single participant. Use
\code{\link[mpathsenser]{get_participants}} to retrieve all participants from the database.
Leave empty to get data for all participants.}

\item{start_date}{Optional search window specifying date where to begin search. Must be
convertible to date using \link[base]{as.Date}. Use \link[mpathsenser]{first_date} to find the
date of the first entry for a participant.}

\item{end_date}{Optional search window specifying date where to end search. Must be convertible
to date using \link[base]{as.Date}. Use \link[mpathsenser]{last_date} to find the date of the
last entry for a participant.}
}
\value{
A named vector containing the number of rows for each sensor.
}
\description{
Get the number of rows sensors in a mpathsenser database
}
