% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legendre.R
\name{legendre}
\alias{legendre}
\title{Legendre polynomials}
\usage{
legendre(degree, indeterminate = "x", normalized = FALSE)
}
\arguments{
\item{degree}{degree of polynomial}

\item{indeterminate}{indeterminate}

\item{normalized}{provide normalized coefficients}
}
\value{
a mpoly object or mpolyList object
}
\description{
Legendre polynomials as computed by orthopolynom.
}
\examples{

legendre(0)
legendre(1)
legendre(2)
legendre(3)
legendre(4)
legendre(5)
legendre(6)

legendre(2)
legendre(2, normalized = TRUE)

legendre(0:5) 
legendre(0:5, normalized = TRUE)
legendre(0:5, indeterminate = "t")



# visualize the legendre polynomials

library(ggplot2); theme_set(theme_bw())
library(reshape2)

s <- seq(-1, 1, length.out = 201)
N <- 5 # number of legendre polynomials to plot
(legPolys <- legendre(0:N))

df <- t(sapply(s, as.function(legPolys)) )
df <- as.data.frame(cbind(s, df))
names(df) <- c("x", paste0("P_", 0:N))
mdf <- melt(df, id = "x")
qplot(x, value, data = mdf, geom = "line", color = variable)



}
\author{
David Kahle calling code from the orthopolynom package
}
\seealso{
\code{\link{legendre.polynomials}}, 
  \url{http://en.wikipedia.org/wiki/Legendre_polynomials}
}

