% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QTL_effect_main_QxE.R
\name{QTL_effect_main_QxE}
\alias{QTL_effect_main_QxE}
\title{Estimation of QTL main effect and QTLxE effect}
\usage{
QTL_effect_main_QxE(
  mppData,
  trait,
  env_id = NULL,
  VCOV = "UN",
  ref_par = NULL,
  QTL = NULL,
  QmainQi = TRUE,
  maxIter = 100,
  msMaxIter = 100
)
}
\arguments{
\item{mppData}{An object of class \code{mppData}.}

\item{trait}{\code{Character vector} specifying which traits (environments) should be used.}

\item{env_id}{\code{Character} vector specifying the environment names.
By default, E1, ... En}

\item{VCOV}{VCOV \code{Character} expression defining the type of variance
covariance structure used. 'CS' for compound symmetry assuming a unique
genetic covariance between environments. 'CSE' for cross-specific within
environment error term. 'CS_CSE' for both compound symmetry plus
cross-specific within environment error term. 'UN' for unstructured
environmental variance covariance structure allowing a specific genotypic
covariance for each pair of environments. Default = 'UN'}

\item{ref_par}{Optional \code{Character} expression defining the parental
allele that will be used as reference for the parental model. Default = NULL}

\item{QTL}{Object of class \code{QTLlist} representing a list of
selected marker positions obtained with the function QTL_select() or
a vector of \code{character} marker positions names. Default = NULL.}

\item{QmainQi}{\code{logical} value specifying how the QTL parental allele
main effects are estimated. For further explanation see the details section.
Default = TRUE}

\item{maxIter}{maximum number of iterations for the lme optimization algorithm.
Default = 100.}

\item{msMaxIter}{maximum number of iterations for the optimization step inside
the lme optimization. Default = 100.}
}
\value{
Return:

\code{List} with one \code{data.frame} per QTL that contains the following
elements:

\enumerate{

\item{QTL parent allele main effect expressed as deviation with respect to
the reference parent}
\item{QTL parent allele effect in environment j expressed as deviation with
respect to the reference parent}
\item{Significance of the parent main effect expressed as the -log10(p-val)}

\item{Significance of the parent QTLxE effect expressed as the -log10(p-val)}

}
}
\description{
Decomposition of the QTL effect into main component across environments and
QTLxE component.
}
\details{
The function estimate the QTL parent allele main effect across environments
as well the QTLxE effect. The significance of the QTL parental main effect
as well as the QTLxE effect are also estimated and returned as -log10(p-value).

The function use two models, one where the QTL parent allele effect are
considered to be different in each environments (QTLxE model) and a model
where the QTL parental effect are assumed to be constant across environment
(QTL main model). Concerning the model to estimate the QTL main effect, there
are two option, the first (default) option (QmainQi = TRUE), estimate a model
where only the ith QTL is defined with a main effect and the other position
are assumed to have parental effect that vary in each environment (same as
the QTLxE model). In that case, the function estimate as many QTL main
model as there are QTL positions to get the main effect estimate of each
QTL position. The alternative option (QmainQi = FALSE), calculate a single
model where all QTL are defined with a main effect term. The estimated
main effect obtained with the two options are generally very similar. The
second option is less time consumming.

The QTL main allelic effect is the deviation of the parental allelic effect
with respect to the reference parent (e.g. the central or recurrent parent
in a NAM population)

The estimation is performed using an exact mixed model with function from R
package \code{nlme}. The significance of the allele effect is assessed using a 
Wald test.
}
\examples{

\dontrun{

data(mppData_GE)

Qpos <- c("PZE.105068880", "PZE.106098900")

Qeff <- QTL_effect_main_QxE(mppData = mppData_GE,
                            trait = c('DMY_CIAM', 'DMY_TUM', 'DMY_INRA_P', 'DMY_KWS'),
                            env_id = c('CIAM', 'TUM', 'INRA', 'KWS'),
                            QTL = Qpos)

Qeff

}

}
\references{
Pinheiro J, Bates D, DebRoy S, Sarkar D, R Core Team (2021). nlme: Linear
and Nonlinear Mixed Effects Models_. R package version 3.1-152,
<URL: https://CRAN.R-project.org/package=nlme>.
}
\author{
Vincent Garin
}
