% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvmr_egger_stan.R
\name{mvmr_egger_stan}
\alias{mvmr_egger_stan}
\title{Bayesian implementation of the MVMR-Egger model with choice of prior distributions fitted using RStan.}
\usage{
mvmr_egger_stan(
  data,
  prior = 1,
  n.chains = 3,
  n.burn = 1000,
  n.iter = 5000,
  seed = 12345,
  rho = 0.5,
  orientate = 1,
  ...
)
}
\arguments{
\item{data}{A data of class \code{\link{mvmr_format}}.}

\item{prior}{An integer for selecting the prior distributions;
\itemize{
\item \code{1} selects a non-informative set of priors;
\item \code{2} selects weakly informative priors;
\item \code{3} selects a pseudo-horseshoe prior on the causal effect;
}}

\item{n.chains}{Numeric indicating the number of chains used in the HMC estimation in rstan, the default is \code{3} chains.}

\item{n.burn}{Numeric indicating the burn-in period of the Bayesian HMC estimation. The default is \code{1000} samples.}

\item{n.iter}{Numeric indicating the number of iterations in the Bayesian HMC estimation. The default is \code{5000} iterations.}

\item{seed}{Numeric indicating the random number seed. The default is \code{12345}.}

\item{rho}{Numeric indicating the correlation coefficient input into the joint prior distribution. The default is \code{0.5}.}

\item{orientate}{Numeric value to indicate the oriented exposure.}

\item{...}{Additional arguments passed through to \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}}.}
}
\value{
An object of class \code{\link{stanfit}}.
}
\description{
Bayesian implementation of the MVMR-Egger model with choice of prior distributions fitted using RStan.
}
\examples{
\donttest{
# Note we recommend setting n.burn and n.iter to larger values

dat <- mvmr_format(rsid = dodata$rsid,
         xbeta = cbind(dodata$ldlcbeta,dodata$hdlcbeta,dodata$tgbeta),
         ybeta = dodata$chdbeta,
         xse = cbind(dodata$ldlcse,dodata$hdlcse,dodata$tgse),
         yse = dodata$chdse)
mvegger_fit <- mvmr_egger_stan(dat, n.burn = 500, n.iter = 1000)
print(mvegger_fit)
}
}
\references{
Bowden J, Davey Smith G, Burgess S. Mendelian randomization with invalid instruments: effect estimation and bias detection through Egger regression. International Journal of Epidemiology, 2015, 44, 2, 512-525. \doi{10.1093/ije/dyv080}.

Stan Development Team (2020). "RStan: the R interface to Stan." R package version 2.19.3, \url{https://mc-stan.org/}.
}
