% Generated by roxygen2 (4.0.2): do not edit by hand
\name{adj.check.order}
\alias{adj.check.order}
\title{Check order of adjustment terms}
\usage{
adj.check.order(adj.series, adj.order, key)
}
\arguments{
\item{adj.series}{Adjustment series used
('\code{cos}','\code{herm}','\code{poly}')}

\item{adj.order}{Integer to check}

\item{key}{key function to be used with this adjustment series}
}
\value{
Nothing! Just calls \code{stop} if something goes wrong.
}
\description{
'adj.check.order' checks that the Cosine, Hermite or simple polynomials are
of the correct order.
}
\details{
Only even functions are allowed as adjustment terms. Also Hermite polynomials must be of degree at least 4 and Cosine of order at least 3. Finally, also checks that order of the terms >1 for half-normal/hazard-rate, as per p.47 of Buckland et al (2001). If incorrect terms are supplied then an error is throw via \code{stop}.
}
\author{
David Miller
}
\references{
S.T.Buckland, D.R.Anderson, K.P. Burnham, J.L. Laake. 1993.
  Robust Models. In: Distance Sampling, eds. S.T.Buckland, D.R.Anderson,
  K.P. Burnham, J.L. Laake. Chapman & Hall.
}
\seealso{
\code{\link{adjfct.cos}}, \code{\link{adjfct.poly}},
  \code{\link{adjfct.herm}}, \code{\link{detfct}}, \code{\link{mcds}},
  \code{\link{cds}}
}
\keyword{methods}

