% Generated by roxygen2 (4.0.1): do not edit by hand
\name{process.data}
\alias{process.data}
\title{Process data for fitting distance sampling detection function}
\usage{
process.data(data, meta.data = list(), check = TRUE)
}
\arguments{
\item{data}{dataframe object}

\item{meta.data}{meta.data options; see \code{\link{ddf}} for a description}

\item{check}{if \code{TRUE} check data for errors in the mrds structure; for
\code{method="ds" check=FALSE}}
}
\value{
\item{xmat}{processed \code{data.frame} with added fields}
  \item{meta.data}{meta.data list}
}
\description{
Sets up dataframe and does some basic error checking. Adds needed fields to
dataframe and to \code{meta.data}.
}
\details{
The function does a number of error checking tasks, creating fields and
adding to \code{meta.data} including:

1) If \code{check=TRUE}, check to make sure the record structure is okay for
mrds data. The number of primary records (observer=1) must equal the number
of secondary records (observer=2). Also, a field in the dataframe is created
\code{timesseen} which counts the number of times an object was detected
0,1,2; if \code{timesseen=0} then the record is tossed from the analysis.
Also if there are differences in the data (distance, size, covariates) for
observer 1 and 2 a warning is issued that the analysis may fail.  The code
assumes these values are the same for both observers.

2) Based on the presence of fields \code{distbegin} and \code{distend}, a
determination is made of whether the data analysis should be based on binned
distances and a field \code{binned} is created, which is \code{TRUE} if the
distance for the observation is binned.  By assigning for each observation
this allows an analysis of a mixture of binned and unbinned distances.

4) Data are restricted such that distances are not greater than \code{width}
and not less than \code{left} if those values are specified in
\code{meta.data}.  If they are not specified then \code{left} defaults to 0
and \code{width} defaults to the largest distance measurement.

5) Determine if an integration range (\code{int.begin} and \code{int.end}
has been specified for the observations.  If it has, add the structure to
\code{meta.data}.  The integration range is typically used for aerial
surveys in which the altitude varies such that the strip width (left to
width) changes with a change in altitude.

6) Fields defined as factors are cleaned up such that any unused levels are
eliminated.

7) If the restrictions placed on the data, eliminated all of the data, the
function stops with an error message
}
\author{
Jeff Laake
}
\keyword{utility}

