% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.fasta.R
\name{as.fasta}
\alias{as.fasta}
\title{as.fasta}
\usage{
as.fasta(seqs)
}
\arguments{
\item{seqs}{(Required.) the sequence/alignment to be displayed. A character vector,  \code{\link[ape]{DNAbin}}, \code{\link[Biostrings]{DNAStringSet}},  \code{\link[Biostrings]{AAStringSet}},
or \code{\link[Biostrings]{RNAStringSet}}.}
}
\value{
A character string in fasta format.
}
\description{
functionality to convert objects to a fasta string. Currently
this can handle character objects which are interpreted as filenames or
several of the popular means of storing sequence data: \code{\link[ape]{DNAbin}}, 
\code{\link[Biostrings]{DNAStringSet}}, \code{\link[Biostrings]{AAStringSet}},
\code{\link[Biostrings]{RNAStringSet}}, \code{\link[Biostrings]{BStringSet}},
\code{\link[Biostrings]{DNAMultipleAlignment}}, \code{\link[Biostrings]{RNAMultipleAlignment}},
 or \code{\link[Biostrings]{AAMultipleAlignment}}.
}
\examples{
seqfile <- system.file("sequences","AHBA.aln",package="msaR")
as.fasta(seqfile)
help("as.fasta")

if (requireNamespace("Biostrings", quietly = TRUE)) {
   seqs <- Biostrings::readDNAStringSet(seqfile)
   as.fasta(seqs)
}

}

