% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.sequences.R
\name{as.sequences}
\alias{as.sequences}
\title{as.sequences}
\usage{
as.sequences(seqs)
}
\arguments{
\item{seqs}{(Required.) the sequence/alignment to be displayed. A character vector,  \code{\link[ape]{DNAbin}}, \code{\link[Biostrings]{DNAStringSet}},  \code{\link[Biostrings]{AAStringSet}},
or \code{\link[Biostrings]{RNAStringSet}}.}
}
\value{
A list of named lists where each sublist has name, id, and seq members.
}
\description{
functionality to convert sequence objects into R lists that can be serialized to 
JS as JSON. Currently, this can handle character objects which are interpreted 
as filenames or several of the popular means of storing sequence data: \code{\link[ape]{DNAbin}}, 
\code{\link[Biostrings]{DNAStringSet}}, \code{\link[Biostrings]{AAStringSet}},
\code{\link[Biostrings]{RNAStringSet}}, \code{\link[Biostrings]{BStringSet}},
\code{\link[Biostrings]{DNAMultipleAlignment}}, \code{\link[Biostrings]{RNAMultipleAlignment}},
 or \code{\link[Biostrings]{AAMultipleAlignment}}.
}
\examples{
seqfile <- system.file("sequences","AHBA.aln",package="msaR")
as.sequences(seqfile)
help("as.sequences")

\dontrun{
if (requireNamespace("Biostrings")) {
   seqs <- readDNAStringSet(seqfile)
   as.sequences(seqs)
 }
}

}
