% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sde.diff.R
\name{sde.diff}
\alias{sde.diff}
\title{SDE diffusion function.}
\usage{
sde.diff(model, x, theta)
}
\arguments{
\item{model}{An \code{sde.model} object.}

\item{x}{A vector or matrix of data with \code{ndims} columns.}

\item{theta}{A vector or matrix of parameters with \code{nparams} columns.}
}
\value{
A matrix with \code{ndims^2} columns containing the diffusion function evaluated at \code{x} and \code{theta}. Each row corresponds to the upper triangular Cholesky factor of the diffusion matrix.  If either input contains invalid SDE data or parameters an error is thrown.
}
\description{
Computes the SDE model's diffusion function given data and parameter values.
}
\examples{
\donttest{
# compile model
hex <- example.models("hest")
hmod <- sde.make.model(ModelFile = hex$ModelFile,
                       param.names = hex$param.names,
                       data.names = hex$data.names)

# single input
theta <- c(alpha = 0.1, gamma = 1, beta = 0.8, sigma = 0.6, rho = -0.8)
x0 <- c(X = log(1000), Z = 0.1)
sde.diff(model = hmod, x = x0, theta = theta)

# multiple inputs
nreps <- 10
Theta <- apply(t(replicate(nreps, theta)), 2, jitter)
X0 <- apply(t(replicate(nreps, x0)), 2, jitter)
sde.diff(model = hmod, x = X0, theta = Theta)

# mixed inputs
sde.diff(model = hmod, x = x0, theta = Theta)
}
}
