% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{mst.knn}
\alias{mst.knn}
\title{Performs the MST-kNN clustering algorithm}
\usage{
mst.knn(distance.matrix, num.cluster)
}
\arguments{
\item{distance.matrix}{A numeric matrix or data.frame with equals numbers of rows and columns representing distances between objects to group.}

\item{num.cluster}{A numeric value representing the suggested number of cluster to yield. It is an optional argument. Note that, due to the algorithm operation, this number may be different at the end of the algorithm execution.}
}
\value{
A list with the elements
\item{cnumber}{A numeric value representing the number of clusters of the solution.}
\item{cluster}{A named vector of integers from \code{1:cnumber} representing the cluster to which each object is assigned.}
\item{partition}{A partition matrix order by cluster where are shown the objects and the cluster where they are assigned.}
\item{csize}{A vector with the cardinality of each cluster in the solution.}
\item{network}{An object of class "igraph" as a network representing the clustering solution.}
}
\description{
Performs the MST-kNN clustering algorithm which generates a clustering solution with automatic \emph{number of clusters} determination using two proximity graphs: Minimal Spanning Tree (MST) and k-Nearest Neighbor (\emph{k}NN) which are recursively intersected.

To create MST, \emph{Prim} algorithm is used. To create \emph{k}NN,  \code{distance.matrix} passed as input is considered.
}
\details{
To see more details of how MST-kNN works refers to the \href{../doc/guide.html}{quick guide}.
}
\examples{

set.seed(1987)

##load package
library("mstknnclust")

##Generates a data matrix of dimension 100X15

n=100; m=15
x <- matrix(runif(n*m, min = -5, max = 10), nrow=n, ncol=m)

##Computes a distance matrix of x.

library("stats")
d <- base::as.matrix(stats::dist(x, method="euclidean"))

##Performs MST-kNN clustering using euclidean distance.

results <- mst.knn(d)

## Visualizes the clustering solution

library("igraph")
plot(results$network, vertex.size=8,
     vertex.color=igraph::clusters(results$network)$membership,
     layout=igraph::layout.fruchterman.reingold(results$network, niter=10000),
     main=paste("MST-kNN \n Clustering solution \n Number of clusters=",results$cnumber,sep="" ))

}
\references{
Inostroza-Ponta, M. (2008). \emph{An Integrated and Scalable Approach Based on Combinatorial Optimization Techniques for the Analysis of Microarray Data}. Ph.D. thesis, School of Electrical Engineering and Computer Science. University of Newcastle.
}
\author{
Mario Inostroza-Ponta, Jorge Parraga-Alava, Pablo Moscato
}
