% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube.R
\docType{class}
\name{Cube}
\alias{Cube}
\title{Extract a MicroStrategy cube into a R Data.Frame}
\format{An object of class \code{R6ClassGenerator} of length 25.}
\usage{
Cube
}
\description{
Access, filter, publish, and extract data from MicroStrategy in-memory cubes
}
\section{Fields}{

\describe{
\item{\code{connection}}{MicroStrategy connection object}

\item{\code{cube_id}}{Identifier of a cube.}
}}

\examples{
\donttest{
# Create a connection object.
connection = connect_mstr(base_url, username, password, project_name)

# Create a cube object.
my_cube <- Cube$new(connection=conn, cube_id="...")

# See attributes and metrics in the report.
my_cube$attributes
my_cube$metrics
my_cube$attr_elements

# Specify attributes and metrics (columns) to be fetched.
my_cube$apply_filters(attributes = my_report$attributes[1:2],
                         metrics = my_report$metrics[1:2])

# See the selection of attributes, metrics and attribute elements.
my_cube$selected_attributes
my_cube$selected_metrics
my_cube$selected_attr_elements

# Clear filtering to load a full dataset.
my_cube$clear_filters()

# Fetch data from the Intelligence Server.
my_cube$to_dataframe()

# See the dataframe.
my_cube$dataframe
}
}
\keyword{datasets}
