\encoding{utf8}
\name{modeforest}
\alias{modeforest}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Mode forest }
\description{
   This function provides the mode forest.
}
\usage{
modeforest(data,bws=NULL,gridsize=NULL,B=99,n=512,cbw1=NULL,cbw2=NULL,
display=TRUE,logbw=FALSE,from=NULL,to=NULL,logbw.regulargrid=NULL,\dots)
}
\arguments{
  \item{data}{ Sample in which the mode forest is computed.}
  \item{bws}{ Vector or range of bandwidths. If it is a vector of size two, then it is used a grid of bandwidths between the given values. Default lower bandwidth is twice the distance between the grid points used for estimating the density and upper bandwidth equal to the range of the data. Unless it is specified a vector of size greater than two, the number of bandwidths employed is equal to the second element of \code{gridsize}.}
  \item{gridsize}{ Number of grid points in the horizontal (values of the variable, first element) and vertical (bandwidths, second element) axis. Default is \code{c(100,151)}.}
  \item{B}{ Number of replicates used for generating the mode forest. Default \code{B=99}.}
  \item{n}{ The number of equally spaced points at which the density is to be estimated. When n > 512, it is rounded up to a power of 2 as in the \code{density} function. Default \code{n=512}.}
  \item{cbw1}{ Number of modes for which the first critical bandwidth is calculated. This is the first bandwidth used to compute the mode tree when \code{bws} is not specified.}
  \item{cbw2}{ Number of modes for which the second critical bandwidth is calculated. This is the last bandwidth used to compute the mode tree when \code{bws} is not specified.}
  \item{display}{ Logical, if \code{TRUE} the mode tree plot is plotted. Default \code{TRUE}.}
  \item{logbw}{ Logical, if \code{TRUE} the plot displays and returns the log10 bandwidths. Default \code{logbw=FALSE}.}
    \item{from}{ First plotted value of the variable. Default is below the data minimum.}
    \item{to}{ Last plotted value of the variable. Default is above the data maximum.}
    \item{logbw.regulargrid}{ Logical, if \code{TRUE} a regular grid of bandwidths is created over the log10 scale. Default \code{logbw.regulargrid=FALSE}.}
    \item{\dots}{ Arguments to be passed to subsequent methods, \code{\link{plot.gtmod}} for the \code{plot}, \code{print} and \code{summary} methods.}
}

\details{

The mode forest for the sample given in \code{data} is computed. For this calculation, a kernel density estimator with Gaussian kernel and bandwidths \code{bws} is used. The mode forest is generated by looking simultaneously at a collection of mode trees generated by the original sample and \code{B} random resamples drawn with replacement from \code{data}. When the mode forest is plotted, this tool represents the number of times an estimated mode falls in each location-bandwidth (horizontal-vertical axis) pixel. The pixels are then shaded  proportionally to counts (large counts corresponding to darker pixels and low counts to lighter ones).

The NAs will be automatically removed.
}
\value{
  A list with class \code{"gtmod"} containing the following components:
  \item{modeforest}{ Matrix including the percentage of times that a mode tree falls in each location-bandwidth pixel.}
  \item{range.x}{ Employed location values to represent the mode forest.}
  \item{range.bws}{ Employed bandwidths to compute the different mode trees.}
    \item{logbw}{ Logical value indicating if the bandwidths are given in the log10 scale.}
  \item{sample.size}{ The number of non-missing observations in the sample used for obtaining the mode forest.}
  \item{call}{ The unevaluated expression, which consists of the named function applied to the given arguments.}
}
\references{

Minnotte, M. C., Marchette, D. J. and Wegman, E. J. (1998). The bumpy road to the mode forest, \emph{Journal of Computational and Graphical Statistics}, \bold{7}, 239--251.

}


\author{ Jose Ameijeiras--Alonso, Rosa M. Crujeiras and Alberto Rodríguez--Casal}

\examples{
#Mode forest using a grid of bandwidths between 0.2 and 0.5 and 29 bootstrap replicas
set.seed(2016)
data=rnorm(50)
modeforest(data,bws=c(0.2,0.5),B=29)
#Original mode tree for this sample
modetree(data,bws=c(0.2,0.5),addplot=TRUE,col.lines="red")
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ graphical tools }% __ONLY ONE__ keyword per line

