\name{Network management: updates}
\alias{Network management: updates}
\alias{add.layers.ml}
\alias{add.actors.ml}
\alias{add.nodes.ml}
\alias{add.edges.ml}

\alias{delete.layers.ml}
\alias{delete.actors.ml}
\alias{delete.nodes.ml}
\alias{delete.edges.ml}
\title{
Manipulation of multilayer networks
}
\description{
Functions to add or remove components of a multilayer network.

The functions \code{add.nodes.ml} and \code{delete.nodes.ml} add/remove the input actors to/from the input layers, but do not add/remove the actors from the multilayer network.
}
\usage{
add.layers.ml(mlnetwork, layers, directed=FALSE)
add.actors.ml(mlnetwork, actors)
add.nodes.ml(mlnetwork, nodes)
add.edges.ml(mlnetwork, edges)

delete.layers.ml(mlnetwork, layers)
delete.actors.ml(mlnetwork, actors)
delete.nodes.ml(mlnetwork, nodes)
delete.edges.ml(mlnetwork, edges)
}
\arguments{
\item{mlnetwork}{A multilayer network}
\item{layers}{An array of names of layers.}
\item{actors}{An array of names of actors.}
\item{directed}{Determines if the layer(s) is (are) directed or undirected. If multiple layers are specified, directed should be either a single value or an array with as many values as the number of layers.}
\item{nodes}{A vector of nodes to be updated. Each node is represented by two consecutive entries in the vector, one specifying an actor name and one specifying a layer name. If this is specified, actors, layers and edges should not.}
\item{edges}{A vector containing the nodes to be connected. Each edge to be created is represented by four consecutive entries in the vector: actor1 name, layer1 name, actor2 name, layer2 name. The directionality of the edge (directed/undirected) is pre-defined depending on the layer(s).}
}
\seealso{
\link{Network management: properties}, \link{Network management: edge directionality}
}
\examples{
net <- ml.empty()
# Adding some layers
add.layers.ml(net,"l1")
add.layers.ml(net,c("l2","l3"),c(TRUE,FALSE))
layers.ml(net)
# Adding some actors
add.actors.ml(net,"A1")
add.actors.ml(net,c("A2","A3"))
actors.ml(net)
num.actors.ml(net)
# Adding some nodes (actor A3 is not present in layer l3: no corresponding node there)
add.nodes.ml(net,c("A1","l1","A2","l1","A3","l1","A1","l2","A2","l2","A3","l2"))
add.nodes.ml(net,c("A1","l3","A2","l3"))
nodes.ml(net)
# We create a vector specifying two edges
e <- c(c("A2","l2","A3","l2"),c("A1","l1","A3","l2"))
# Or, equivalently: e <- c("A2","l2","A3","l2","A1","l1","A3","l2")
# If the edges are available in a matrix M, e.g.,
#      [,1] [,2] [,3] [,4]
# [1,] "a1" "l1" "a2" "l2"
# [2,] "a1" "l1" "a2" "l2"
# Then as.vector(t(M)) creates the requested input parameter
add.edges.ml(net,e)
edges.ml(net)

# The following also deletes all nodes from "l1" and the edge with an end-point in "l1"
delete.layers.ml(net,"l1")
# The following also deletes the nodes associated to "A1" in layers "l2" and "l3"
delete.actors.ml(net,"A1")
# nodes and edges
delete.nodes.ml(net,c("A2","l3"))
e <- c("A2","l2","A3","l2")
delete.edges.ml(net,e)
net
}