% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_data-class.R
\name{get_nodesplits}
\alias{get_nodesplits}
\alias{has_direct}
\alias{has_indirect}
\title{Direct and indirect evidence}
\usage{
get_nodesplits(network, include_consistency = FALSE)

has_direct(network, trt1, trt2)

has_indirect(network, trt1, trt2)
}
\arguments{
\item{network}{An \code{nma_data} object, as created by the functions \verb{set_*()} or
\code{combine_network()}.}

\item{include_consistency}{Logical, whether to include a row of \code{NA}s to
indicate that a consistency model (i.e. a model with no node-splitting)
should also be fitted by the \code{\link[=nma]{nma()}} function. Default is \code{FALSE} when
calling \code{get_nodesplits()} by hand, and \code{\link[=nma]{nma()}} sets this to \code{TRUE} by
default.}

\item{trt1, trt2}{Treatments, each as a single integer, string, or factor}
}
\value{
For \code{has_direct()} and \code{has_indirect()}, a single logical value. For
\code{get_nodesplits()}, a data frame with two columns giving the comparisons
for node-splitting.
}
\description{
Determine whether two treatments in a network are connected by direct and/or
indirect evidence, and generate a list of comparisons with both direct and
indirect evidence (i.e. potential inconsistency) for node-splitting.
}
\details{
The list of comparisons for node-splitting is generated following
the algorithm of \insertCite{Valkenhoef2016;textual}{multinma}. A
comparison between two treatments has the potential for inconsistency, and
is thus considered for node-splitting, if the comparison has both direct
evidence and \emph{independent} indirect evidence.

The notion of independent indirect evidence is necessary when multi-arm
trials are present, since by design these trials are internally consistent.
A comparison between two treatments has independent indirect evidence if,
after removing all studies comparing the two treatments from the network,
the two treatments are still connected by a path of evidence. This is the
criterion considered by the \code{has_indirect()} function.
}
\examples{
# Parkinsons example
park_net <- set_agd_arm(parkinsons,
                        study = studyn,
                        trt = trtn,
                        y = y,
                        se = se,
                        trt_ref = 1)

# View the network plot
plot(park_net)

# The 4 vs. 5 comparison is a spur on the network
has_direct(park_net, 4, 5)
has_indirect(park_net, 4, 5)

# 1 and 5 are not directly connected
has_direct(park_net, 1, 5)
has_indirect(park_net, 1, 5)

# The 1 vs. 2 comparison does not have independent indirect evidence, since
# the 1-2-4 loop is a multi-arm study
has_indirect(park_net, 1, 2)

# Get a list of comparisons with potential inconsistency for node-splitting
get_nodesplits(park_net)

# See van Valkenhoef (2016) for a discussion of this example
}
\references{
\insertAllCited{}
}
