% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_hilbig2014_heck2017.R
\docType{data}
\name{hilbig2014}
\alias{hilbig2014}
\title{Data: Multiattribute Decisions (Hilbig & Moshagen, 2014)}
\format{
A data frame 3 variables:
\describe{
  \item{\code{B1}}{Frequency of choosing Option B for Item Type 1}
  \item{\code{B2}}{Frequency of choosing Option B for Item Type 2}
  \item{\code{B3}}{Frequency of choosing Option B for Item Type 3}
}
}
\usage{
hilbig2014
}
\description{
Choice frequencies of multiattribute decisions across 3 item types (Hilbig & Moshagen, 2014).
}
\details{
Each participant made 32 choices for each of 3 item types with four cues (with validities .9, .8, .7, and .6).

The pattern of cue values of Option A and and B was as follows:
\itemize{
  \item{Item Type 1: }{A = (1, 1, 1, -1) vs. B = (-1, 1, -1, 1)}
  \item{Item Type 2: }{A = (1, -1, -1, -1) vs. B = (-1, 1, 1, -1)}
  \item{Item Type 3: }{A = (1, 1, 1, -1) vs. B = (-1, 1, 1, 1)}
}
}
\examples{
data(hilbig2014)
head(hilbig2014)

# validities and cue values
v <- c(.9, .8, .7, .6)
cueA <- matrix(c(1,  1,  1, -1,
                 1, -1, -1, -1,
                 1,  1,  1, -1),
               ncol = 4, byrow = TRUE)
cueB <- matrix(c(-1, 1, -1,  1,
                 -1, 1,  1, -1,
                 -1, 1,  1,  1),
               ncol = 4, byrow = TRUE)

# get strategy predictions
strategies <- c("baseline", "WADDprob", "WADD",
                "TTB", "EQW", "GUESS")
preds <- strategy_multiattribute(cueA, cueB, v, strategies)
c <- c(1, rep(.5, 5))  # upper bound of probabilities

# use Bayes factor for strategy classification
n <- rep(32, 3)
strategy_postprob(k = hilbig2014[1:5,], n, preds)
}
\references{
Hilbig, B. E., & Moshagen, M. (2014). Generalized outcome-based strategy classification: Comparing deterministic and probabilistic choice models. Psychonomic Bulletin & Review, 21(6), 1431-1443. \doi{10.3758/s13423-014-0643-0}
}
\keyword{datasets}
