% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pl_est_com.R
\name{pl_est_com}
\alias{pl_est_com}
\title{Fits the stochastic block model using maximum pseudolikelihood estimation}
\usage{
pl_est_com(X, K = NULL, max.iter = 1000, tol = 1e-08,
  parallel = FALSE)
}
\arguments{
\item{X}{n x n adjacency matrix}

\item{K}{number of communities; by default, chosen using the method of Le and Levina (2015)}

\item{max.iter}{maximum number of iterations for the EM algorithm}

\item{tol}{the EM algorithm stops when the relative tolerance is less than this value}

\item{parallel}{An optional argument allowing for parallel computing using the 
doParallel package}
}
\value{
A list containing the following components:
\item{eta}{Estimate of eta, a K x K matrix defined in Amini et. al. (2013)}
\item{pi}{Estimate of the community membership probabilities}
\item{ploglik}{The maximum of the pseudolikelihood function}
\item{logphi}{n x K matrix, where (i, k)th entry contains the log p.m.f. of a multinomial
random variable with probability vector eta_k (the kth row of eta), evaluated at b_i, 
which is the ith row of the block compression matrix defined in Amini et. al. (2013)}
\item{responsibilities}{n x K matrix containing the responsibilities/soft cluster 
memberships for the n nodes}
\item{class}{A vector containing n (hard) cluster memberships for the n nodes}
\item{converged}{whether the algorithm converged to the desired tolerance}
}
\description{
Fits the stochastic block model using maximum
pseudolikelihood estimation, as proposed by Amini et. al. (2013). 
This function implements the conditional pseudolikelihood algorithm 
from Amini et al. (2013).
}
\examples{
# 50 draws from a stochastic block model for two network data views 
# where the communities are dependent
n <- 50
Pi <- diag(c(0.5, 0.5))
theta1 <- rbind(c(0.5, 0.1), c(0.1, 0.5))
theta2 <- cbind(c(0.1, 0.5), c(0.5, 0.1))

dat <- mv_sbm_gen(n, Pi, theta1, theta2)

# Fit SBM to view 1
results <- pl_est_com(X=dat$data$view1, K = 2)
table(results$class, dat$communities$view1)

}
\references{
Amini, A. A., Chen, A., Bickel, P. J., & Levina, E. (2013). 
Pseudo-likelihood methods for community detection in large sparse networks. 
The Annals of Statistics, 41(4), 2097-2122.

Le, C. M., & Levina, E. (2015). Estimating the number of communities 
in networks by spectral methods. arXiv preprint arXiv:1507.00827.
}
