% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Anova.mp.R
\name{Anova.mp}
\alias{Anova.mp}
\title{Get ANOVA-style results for a multinomial-Poisson model}
\usage{
Anova.mp(model, type = c(3, 2, 1, "III", "II", "I"))
}
\arguments{
\item{model}{A model built by \code{\link{glm.mp}} or \code{\link{glmer.mp}}. (The underlying model
will have been built by \code{\link[stats]{glm}} or \code{\link[lme4]{glmer}}, with
\code{family=poisson}.)}

\item{type}{In the case of a type II or type III ANOVA, this value will be the \code{type} parameter
passed to \code{\link[car]{Anova}}. In the case of a type I ANOVA, for models built with
\code{\link{glm.mp}}, the \code{\link[stats]{anova.glm}} function will be called; for models built with
\code{\link{glmer.mp}}, the \code{\link[lme4]{anova.merMod}} function will be called.
The default is type 3. See the Details section for \code{\link[car]{Anova}}.}
}
\value{
An ANOVA-style table of chi-square results for models built by \code{\link{glm.mp}} or
\code{\link{glmer.mp}}. See the return values for \code{\link[car]{Anova}}, \code{\link[stats]{anova.glm}},
or \code{\link[lme4]{anova.merMod}}.
}
\description{
Get ANOVA-style results for a model returned by \code{\link{glm.mp}} or \code{\link{glmer.mp}}.
The output table contains chi-square results for the main effects and interactions indicated by
the given model.
}
\details{
For type II or III ANOVAs, the \code{Anova.mp} function uses \code{\link[car]{Anova}} behind the scenes to
produce an ANOVA-style table with chi-square results. For type I ANOVAs, it uses
\code{\link[stats]{anova.glm}} or \code{\link[lme4]{anova.merMod}}.

Users wishing to verify the correctness of these results can compare \code{\link[car]{Anova}} results
for dichotomous response models built with \code{\link[stats]{glm}} or \code{\link[lme4]{glmer}} (using
\code{family=binomial}) to \code{Anova.mp} results for models built with \code{\link{glm.mp}} or
\code{\link{glmer.mp}}, respectively. The results should generally match, or be very similar.

Users can also compare \code{\link[car]{Anova}} results for polytomous response models built with
\code{\link[nnet]{multinom}} to \code{Anova.mp} results for models built with \code{\link{glm.mp}}.
Again, the results should generally match, or be very similar.

There is no similarly easy comparison for polytomous response models with repeated measures. The
lack of options was a key motivation for developing \code{\link{glmer.mp}} in the first place.
}
\examples{
## between-subjects factors (X1,X2) with polytomous response (Y)
data(bs3, package="multpois")

bs3$PId = factor(bs3$PId)
bs3$Y = factor(bs3$Y)
bs3$X1 = factor(bs3$X1)
bs3$X2 = factor(bs3$X2)
contrasts(bs3$X1) <- "contr.sum"
contrasts(bs3$X2) <- "contr.sum"

m1 = glm.mp(Y ~ X1*X2, data=bs3)
Anova.mp(m1, type=3)

## within-subjects factors (X1,X2) with polytomous response (Y)
data(ws3, package="multpois")

ws3$PId = factor(ws3$PId)
ws3$Y = factor(ws3$Y)
ws3$X1 = factor(ws3$X1)
ws3$X2 = factor(ws3$X2)
contrasts(ws3$X1) <- "contr.sum"
contrasts(ws3$X2) <- "contr.sum"

m2 = glmer.mp(Y ~ X1*X2 + (1|PId), data=ws3)
Anova.mp(m2, type=3)

}
\references{
Baker, S.G. (1994). The multinomial-Poisson transformation.
\emph{The Statistician 43} (4), pp. 495-504. \doi{10.2307/2348134}

Chen, Z. and Kuo, L. (2001). A note on the estimation of the
multinomial logit model with random effects. \emph{The American Statistician
55} (2), pp. 89-95. \url{https://www.jstor.org/stable/2685993}

Guimaraes, P. (2004). Understanding the multinomial-Poisson
transformation. \emph{The Stata Journal 4} (3), pp. 265-273.
\url{https://www.stata-journal.com/article.html?article=st0069}

Lee, J.Y.L., Green, P.J.,and Ryan, L.M. (2017). On the “Poisson
trick” and its extensions for fitting multinomial regression models. \emph{arXiv
preprint} available at \doi{10.48550/arXiv.1707.08538}
}
\seealso{
\code{\link[=glm.mp]{glm.mp()}}, \code{\link[=glm.mp.con]{glm.mp.con()}}, \code{\link[=glmer.mp]{glmer.mp()}}, \code{\link[=glmer.mp.con]{glmer.mp.con()}}, \code{\link[car:Anova]{car::Anova()}}
}
\author{
Jacob O. Wobbrock
}
