/*
 * Decompiled with CFR 0.152.
 */
package af.statguitoolkit.io.datasets;

import af.statguitoolkit.io.datasets.DataFrameDescriptor;
import af.statguitoolkit.io.datasets.FileDescriptorCSV;
import af.statguitoolkit.io.datasets.FileDescriptorXLS;
import af.statguitoolkit.io.datasets.RDataFrameDescriptor;
import af.statguitoolkit.io.datasets.RFileFormatException;
import af.statguitoolkit.io.datasets.RVariableDescriptor;
import af.statguitoolkit.io.datasets.XLSToolkit;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.af.jhlir.call.RDataFrame;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSetLoader {
    private static final Log logger = LogFactory.getLog(DataSetLoader.class);
    private static DataSetLoader instance = null;
    private Random random = new Random();

    private DataSetLoader() {
    }

    public static DataSetLoader getInstance() {
        if (instance == null) {
            instance = new DataSetLoader();
        }
        return instance;
    }

    private RDataFrame loadXLS(File file, int sheet, boolean header, Character dec, String missing) throws RFileFormatException, IOException {
        logger.info((Object)("Converting to CSV: " + file.getAbsolutePath()));
        logger.info((Object)("Sheet: " + sheet));
        long nr = Math.abs(this.random.nextLong());
        String name = "tempcsv_" + nr + ".csv";
        File csv = new File(this.getProjectDataSetsPath(), name);
        logger.info((Object)("Output CSV: " + csv.getAbsolutePath()));
        XLSToolkit.convertXls2Csv(file, sheet, csv, ";");
        logger.info((Object)"Loading CSV");
        RDataFrame dfR = this.loadCSV(csv, header, ";", dec, missing);
        return dfR;
    }

    private RDataFrame loadCSV(File csv, boolean header, String string, Character dec, String missing) {
        return null;
    }

    private String getProjectDataSetsPath() {
        return null;
    }

    public RDataFrame load(DataFrameDescriptor dfd) throws RFileFormatException, IOException {
        RDataFrame dfR;
        if (dfd instanceof RDataFrameDescriptor) {
            RDataFrameDescriptor rdfd = (RDataFrameDescriptor)dfd;
            dfR = this.loadRDataSet(rdfd.getName(), rdfd.getRPackage());
        } else if (dfd instanceof RVariableDescriptor) {
            dfR = ((RVariableDescriptor)dfd).getDataFrame();
        } else if (dfd instanceof FileDescriptorXLS) {
            FileDescriptorXLS xls = (FileDescriptorXLS)dfd;
            dfR = this.loadXLS(xls.file, xls.sheet, xls.headerInFile, xls.dec, xls.na);
        } else {
            FileDescriptorCSV csv = (FileDescriptorCSV)dfd;
            dfR = this.loadCSV(csv.file, csv.headerInFile, csv.separator, csv.dec, csv.na);
        }
        return dfR;
    }

    private RDataFrame loadRDataSet(String name, String rPackage) {
        return null;
    }
}

