% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-mwaved.R
\name{plot.mWaveD}
\alias{plot.mWaveD}
\title{Plot Output for the mWaveD object}
\usage{
\method{plot}{mWaveD}(
  x,
  ...,
  which = 1L:4L,
  singlePlot = TRUE,
  ask = !singlePlot,
  ggplot = TRUE
)
}
\arguments{
\item{x}{A mWaveD object to be plotted (list created by \code{\link{multiWaveD}})}

\item{...}{Arguments to be passed to methods.}

\item{which}{A numeric vector that specifies which plots to output. Default value is \code{1:4} which  specifies that all four plots are to be displayed.}

\item{singlePlot}{A logical value that controls whether all plots should appear on a single window. The plot window is resized depending on the value of \code{which}.}

\item{ask}{A logical value that specifies whether the user is \emph{ask}ed before each plot output.}

\item{ggplot}{A logical value to specify if the user wants to use base graphics (FALSE) or ggplot2 graphics (TRUE).}
}
\description{
Creates plot output that summarises the \code{mWaveD} object produced by the \code{\link{multiWaveD}} function.
}
\details{
Four plots are output that summarise the multichannel input, a visualisation of the characteristics of the channels and the output estimate and a multi-resolution analysis plot.\itemize{
\item Plot 1: Multichannel input signal overlayed.
\item Plot 2: Estimated output signal using the mWaveD approach.
\item Plot 3: Plot of the log decay of Fourier coefficients against the log bounds (direct and smooth case) or the blockwise resolution levels against their limit (box car case)
\item Plot 4: Multi-resolution plot of the raw wavelet coefficients and the trimmed wavelet coefficients}
}
\references{
Kulik, R., Sapatinas, T. and Wishart, J.R. (2014) \emph{Multichannel wavelet deconvolution with long range dependence. Upper bounds on the L_p risk}  Appl. Comput. Harmon. Anal. (to appear in).
\doi{10.1016/j.acha.2014.04.004}

Wishart, J.R. (2014) \emph{Data-driven wavelet resolution choice in multichannel box-car deconvolution with long memory}, Proceedings of COMPSTAT 2014, Geneva Switzerland, Physica Verlag, Heidelberg (to appear)
}
\seealso{
\code{\link{multiWaveD}}
}
