/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.sgmwcs.solver;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Node;

public class MSTSolver {
    private final Graph g;
    private final Map<Edge, Double> ws;
    private final Node root;
    private double cost;
    private Set<Edge> res;

    public MSTSolver(Graph g, Map<Edge, Double> edgeWeights, Node root) {
        this.g = g;
        this.ws = edgeWeights;
        this.root = root;
    }

    public double getCost() {
        return this.cost;
    }

    public Set<Edge> getEdges() {
        return this.res;
    }

    public void solve() {
        double cost = 0.0;
        HashSet<Edge> res = new HashSet<Edge>();
        HashSet<Node> unvisited = new HashSet<Node>(this.g.vertexSet());
        Node cur = this.root;
        unvisited.remove(this.root);
        PriorityQueue<Edge> q = new PriorityQueue<Edge>(Comparator.comparingDouble(this.ws::get));
        for (int i = 0; i < this.g.vertexSet().size() - 1; ++i) {
            for (Edge e : this.g.edgesOf(cur)) {
                Node nbor = this.g.getOppositeVertex(cur, e);
                if (!unvisited.contains(nbor)) continue;
                q.add(e);
            }
            Edge e = (Edge)q.remove();
            Node et = this.g.getEdgeTarget(e);
            Node es = this.g.getEdgeSource(e);
            if (!unvisited.contains(et) && !unvisited.contains(es)) continue;
            cost += this.ws.get(e).doubleValue();
            res.add(e);
            cur = unvisited.contains(et) ? et : es;
            unvisited.remove(cur);
        }
        this.cost = cost;
        this.res = res;
    }
}

