/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import ru.itmo.ctlab.gmwcs.solver.TreeSolverKt;
import ru.itmo.ctlab.gmwcs.solver.preprocessing.PreprocessorKt;
import ru.itmo.ctlab.virgo.SolverException;
import ru.itmo.ctlab.virgo.TimeLimit;
import ru.itmo.ctlab.virgo.gmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.gmwcs.graph.Elem;
import ru.itmo.ctlab.virgo.gmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.gmwcs.graph.SimpleIO;
import ru.itmo.ctlab.virgo.gmwcs.solver.BicomponentSolver;
import ru.itmo.ctlab.virgo.sgmwcs.Signals;
import ru.itmo.ctlab.virgo.sgmwcs.graph.GraphIO;
import ru.itmo.ctlab.virgo.sgmwcs.graph.GraphPrinter;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Node;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Unit;
import ru.itmo.ctlab.virgo.sgmwcs.solver.ComponentSolver;
import ru.itmo.ctlab.virgo.sgmwcs.solver.Utils;

public class Main {
    public static final String VERSION = "0.1.5";

    private static void checkCplex() {
        PrintStream stdout = System.out;
        try {
            System.setOut(System.err);
            Class<?> c = Class.forName("ilog.cplex.IloCplex");
            c.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            System.err.println("CPLEX jar file couldn't be found. ");
            System.exit(1);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                System.err.println("A problem occurred during initialization: " + e.getMessage());
            }
            System.err.println("CPLEX cannot be initialized.");
            System.exit(1);
        }
        finally {
            System.setOut(stdout);
        }
    }

    private static OptionSet parseArgs(String[] args2) throws IOException {
        OptionParser optionParser = new OptionParser();
        optionParser.allowsUnrecognizedOptions();
        optionParser.acceptsAll(Arrays.asList("h", "help"), "Print a short help message");
        optionParser.accepts("version");
        OptionSet optionSet = optionParser.parse(args2);
        optionParser.acceptsAll(Arrays.asList("n", "nodes"), "Node list file").withRequiredArg().required();
        optionParser.acceptsAll(Arrays.asList("e", "edges"), "Edge list file").withRequiredArg().required();
        optionParser.acceptsAll(Arrays.asList("s", "signals"), "Signals file").withOptionalArg();
        optionParser.acceptsAll(Arrays.asList("m", "threads"), "Number of threads").withRequiredArg().ofType(Integer.class).defaultsTo(1, (Integer[])new Integer[0]);
        optionParser.acceptsAll(Arrays.asList("t", "timelimit"), "Timelimit in seconds (<= 0 - unlimited)").withRequiredArg().ofType(Long.class).defaultsTo(0L, (Long[])new Long[0]);
        optionParser.accepts("type", "One of: SGMWCS, GMWCS").withRequiredArg().ofType(String.class).defaultsTo("sgmwcs", (String[])new String[0]);
        optionParser.accepts("c", "Threshold for CPE solver").withRequiredArg().ofType(Integer.class).defaultsTo(25, (Integer[])new Integer[0]);
        optionParser.acceptsAll(Arrays.asList("p", "epsilon"), "Maximum allowed absolute score error for solver").withRequiredArg().ofType(Double.class).defaultsTo(0.0, (Double[])new Double[0]);
        optionParser.acceptsAll(Arrays.asList("l", "log"), "Log level").withRequiredArg().ofType(Integer.class).defaultsTo(0, (Integer[])new Integer[0]);
        optionParser.acceptsAll(Arrays.asList("bm", "benchmark"), "Benchmark output file").withOptionalArg().defaultsTo("", (String[])new String[0]);
        optionParser.acceptsAll(Arrays.asList("pl", "preprocessing-level"), "Disable preprocessing").withOptionalArg().ofType(Integer.class).defaultsTo(2, (Integer[])new Integer[0]);
        optionParser.acceptsAll(Arrays.asList("o", "output-dir"), "Solver output directory").withOptionalArg().ofType(String.class);
        optionParser.accepts("mst", "Use primal heuristic only");
        if (optionSet.has("h")) {
            optionParser.printHelpOn(System.out);
            System.exit(0);
        }
        if (optionSet.has("version")) {
            System.out.println("sgmwcs-solver version 0.1.5");
            System.exit(0);
        }
        try {
            optionSet = optionParser.parse(args2);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println();
            optionParser.printHelpOn(System.err);
            System.exit(1);
        }
        return optionSet;
    }

    public static void main(String[] args2) {
        OptionSet optionSet = null;
        try {
            optionSet = Main.parseArgs(args2);
        }
        catch (IOException e2) {
            System.exit(2);
        }
        long timelimit = (Long)optionSet.valueOf("timelimit");
        int threshold = (Integer)optionSet.valueOf("c");
        TimeLimit tl = new TimeLimit(timelimit <= 0L ? Double.POSITIVE_INFINITY : (double)timelimit);
        int threads = (Integer)optionSet.valueOf("m");
        File nodeFile = new File((String)optionSet.valueOf("nodes"));
        File edgeFile = new File((String)optionSet.valueOf("edges"));
        double edgePenalty = (Double)optionSet.valueOf("p");
        int logLevel = (Integer)optionSet.valueOf("l");
        int preprocessLevel = (Integer)optionSet.valueOf("pl");
        boolean heuristicOnly = optionSet.has("mst");
        if (!heuristicOnly) {
            Main.checkCplex();
        }
        String instanceType = (String)optionSet.valueOf("type");
        String outDir = optionSet.has("o") ? (String)optionSet.valueOf("o") : nodeFile.getAbsoluteFile().getParent();
        String statsFile = outDir + "/" + (optionSet.has("f") ? (String)optionSet.valueOf("f") : "stats.tsv");
        try {
            Files.createDirectories(Paths.get(outDir, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e3) {
            System.err.println("Incorrect output path: " + outDir);
            System.exit(1);
        }
        if (edgePenalty < 0.0) {
            System.err.println("Edge penalty can't be negative");
            System.exit(1);
        }
        long before = System.currentTimeMillis();
        if (instanceType.equals("sgmwcs")) {
            File signalFile = new File((String)optionSet.valueOf("signals"));
            ComponentSolver solver = new ComponentSolver(threshold, edgePenalty);
            solver.setThreadsNum(threads);
            solver.setTimeLimit(tl);
            solver.setLogLevel(logLevel);
            solver.setPreprocessingLevel(preprocessLevel);
            solver.setCplexOff(heuristicOnly);
            GraphIO graphIO = new GraphIO(nodeFile, edgeFile, signalFile, outDir);
            try {
                ru.itmo.ctlab.virgo.sgmwcs.graph.Graph graph = graphIO.read();
                System.out.println("Graph with " + graph.edgeSet().size() + " edges and " + graph.vertexSet().size() + " nodes");
                Signals signals = graphIO.getSignals();
                List<Unit> units = solver.solve(graph, signals);
                long now = System.currentTimeMillis();
                if (solver.isSolvedToOptimality()) {
                    System.out.println("SOLVED TO OPTIMALITY");
                }
                double sum = Utils.sum(units, signals);
                long timeConsumed = now - before;
                System.out.println("time:" + timeConsumed);
                System.out.println(sum);
                HashSet<ru.itmo.ctlab.virgo.sgmwcs.graph.Edge> edges = new HashSet<ru.itmo.ctlab.virgo.sgmwcs.graph.Edge>();
                HashSet<Node> nodes = new HashSet<Node>();
                if (logLevel >= 1 && units != null) {
                    for (Unit unit : units) {
                        if (unit instanceof ru.itmo.ctlab.virgo.sgmwcs.graph.Edge) {
                            edges.add((ru.itmo.ctlab.virgo.sgmwcs.graph.Edge)unit);
                            continue;
                        }
                        nodes.add((Node)unit);
                    }
                    ru.itmo.ctlab.virgo.sgmwcs.graph.Graph solGraph = graph.subgraph(nodes, edges);
                    if (logLevel == 2) {
                        new GraphPrinter(solGraph, signals).toTSV(outDir + "/nodes-sol.tsv", outDir + "/edges-sol.tsv");
                    }
                    Main.printStats(solver.isSolvedToOptimality() ? 1 : 0, solver.preprocessedNodes(), solver.preprocessedEdges(), solGraph.vertexSet().size(), solGraph.edgeSet().size(), timeConsumed, statsFile, nodeFile.getAbsolutePath(), edgeFile.getAbsolutePath(), signalFile.getAbsolutePath());
                }
                graphIO.write(units);
            }
            catch (ParseException e4) {
                System.err.println("Couldn't parse input files: " + e4.getMessage() + " " + e4.getErrorOffset());
                System.exit(1);
            }
            catch (SolverException e5) {
                System.err.println("Error occurred while solving:" + e5.getMessage());
                System.exit(1);
            }
            catch (IOException e6) {
                System.err.println("Error occurred while reading/writing input/output files");
                System.exit(1);
            }
        } else if (instanceType.equals("gmwcs") || instanceType.equals("mwcs")) {
            SimpleIO graphIO = new SimpleIO(nodeFile, new File(outDir + "/" + nodeFile.getName() + ".out"), edgeFile, new File(outDir + "/" + edgeFile.getName() + ".out"));
            if (instanceType.equals("mwcs")) {
                graphIO.mwcs();
            }
            try {
                List<Elem> units;
                Graph graph = graphIO.read();
                boolean toOpt = false;
                int prepNodes = 0;
                int prepEdges = 0;
                if (edgePenalty > 0.0) {
                    graph.edgeSet().forEach(e -> e.setWeight(e.getWeight() - edgePenalty));
                }
                if (heuristicOnly) {
                    PreprocessorKt.setThreads(threads);
                    units = Elem.extract(TreeSolverKt.solveComponents(graph));
                    units.forEach(Elem::clear);
                } else {
                    BicomponentSolver solver = new BicomponentSolver();
                    if (logLevel < 2) {
                        solver.suppressOutput();
                    }
                    PreprocessorKt.setLogLevel(logLevel);
                    solver.setThreadsNum(threads);
                    solver.setUnrootedTL(tl);
                    solver.setRootedTL(tl.subLimit(0.7));
                    solver.setTLForBiggest(tl);
                    units = solver.solve(graph);
                    toOpt = solver.isSolvedToOptimality();
                    prepEdges = solver.preprocessedEdges();
                    prepNodes = solver.preprocessedNodes();
                }
                long timeConsumed = System.currentTimeMillis() - before;
                System.out.println("time:" + timeConsumed);
                System.out.println(units.stream().mapToDouble(Elem::getWeight).sum());
                int edgeSize = (int)units.stream().filter(x -> x instanceof Edge).count();
                int nodeSize = units.size() - edgeSize;
                units.forEach(u -> {
                    if (u instanceof Edge) {
                        u.setWeight(u.getWeight() + edgePenalty);
                    }
                });
                graphIO.write(units);
                if (logLevel >= 1) {
                    Main.printStats(toOpt ? 1 : 0, prepNodes, prepEdges, nodeSize, edgeSize, 0L, statsFile, nodeFile.getAbsolutePath(), edgeFile.getAbsolutePath(), "NULL");
                }
            }
            catch (ParseException e7) {
                System.err.println("Couldn't parse input files: " + e7.getMessage() + " " + e7.getErrorOffset());
                System.exit(1);
            }
            catch (SolverException e8) {
                System.err.println("Error occur while solving:" + e8.getMessage());
                System.exit(1);
            }
            catch (IOException e9) {
                System.err.println("Error occurred while reading/writing input/output files");
                System.exit(1);
            }
        }
    }

    private static void printStats(int isOpt, int prepNodes, int prepEdges, int solNodes, int solEdges, long timeConsumed, String fileName, String nodesFile, String edgesFile, String signalsFile) {
        try (PrintWriter pw = new PrintWriter(fileName);){
            String header = "isOpt\tVPrep\tEPrep\ttime\tnodes\tedges\tnodefile\tedgefile\tsigfile\tversion\n";
            String out = isOpt + "\t" + prepNodes + "\t" + prepEdges + "\t" + timeConsumed + "\t" + solNodes + "\t" + solEdges + "\t" + nodesFile + "\t" + edgesFile + "\t" + signalsFile + "\t" + VERSION + "\n";
            pw.write(header);
            pw.write(out);
        }
        catch (IOException e) {
            System.err.println("Failed to write stats");
        }
    }
}

