% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_distribution_pTAI.R
\name{plot_distribution_pTAI}
\alias{plot_distribution_pTAI}
\title{Partial TAI Distribution Plotting Functions}
\usage{
plot_distribution_pTAI(
  phyex_set,
  stages = NULL,
  xlab = "Expression / Partial TAI",
  ylab = "Density",
  main = "Density Distribution of Expression / Partial TAI by Developmental Stage"
)
}
\arguments{
\item{phyex_set}{A PhyloExpressionSet object (BulkPhyloExpressionSet or ScPhyloExpressionSet).}

\item{stages}{A numeric vector specifying the indices of the stages to compare. Each index 
corresponds to a stage in the PhyloExpressionSet. If NULL, all stages are used.}

\item{xlab}{Label of x-axis.}

\item{ylab}{Label of y-axis.}

\item{main}{Figure title.}
}
\value{
A ggplot2 object showing partial TAI distributions
}
\description{
Functions for plotting and comparing partial TAI distributions using PhyloExpressionSet S7 objects.

\emph{plot_distribution_pTAI} generates 2 plots that help to compare the distribution
of the quotient of expression by partial TAI through various developmental stages or cell types, highlighting each stage with 
distinct colors.
}
\author{
Filipa Martins Costa
}
