% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_reductive_hourglass_test.R
\name{reductive_hourglass_score}
\alias{reductive_hourglass_score}
\title{Reductive Hourglass Score Function}
\usage{
reductive_hourglass_score(txi, modules)
}
\arguments{
\item{txi}{Numeric vector of transcriptomic index values}

\item{modules}{A named list with elements 'early', 'mid', and 'late' containing
stage indices for each developmental module}
}
\value{
A numeric value representing the reductive hourglass score
}
\description{
Compute the reductive hourglass score by comparing early and late
developmental stages to mid stages.
}
\details{
The score is computed as the minimum of:
- D1: mean(early) - mean(mid)
- D2: mean(late) - mean(mid)

Higher scores indicate stronger reductive hourglass patterns (mid stages
dominated by older genes).
# Compute reductive hourglass score
# modules <- list(early = 1:3, mid = 4:6, late = 7:9)
# score <- reductive_hourglass_score(txi_values, modules)
}
\keyword{internal}
