% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_generic_conservation_test.R
\name{stat_generic_conservation_test}
\alias{stat_generic_conservation_test}
\title{Generic Conservation Test Framework}
\usage{
stat_generic_conservation_test(
  phyex_set,
  test_name,
  scoring_function,
  fitting_dist,
  alternative = c("two-sided", "greater", "less"),
  p_label = p_label,
  custom_null_txis = NULL,
  plot_result = TRUE
)
}
\arguments{
\item{phyex_set}{A PhyloExpressionSet object}

\item{test_name}{Character string naming the test}

\item{scoring_function}{Function to compute test statistic from TXI profile}

\item{fitting_dist}{Distribution object for fitting the null distribution}

\item{alternative}{Character string specifying alternative hypothesis: 
"two-sided", "greater", or "less" (default: "two-sided")}

\item{p_label}{Label for p-value in results (default: p_label)}

\item{custom_null_txis}{Optional custom null TXI distribution (default: NULL)}

\item{plot_result}{Logical indicating whether to plot results (default: TRUE)}
}
\value{
A ConservationTestResult object containing test statistics and p-values
}
\description{
Perform a generic conservation test by comparing observed TXI patterns
against a null distribution generated by permutation.
}
\details{
This function provides a generic framework for conservation testing by:
1. Generating null TXI distributions via permutation
2. Computing test statistics using the provided scoring function
3. Fitting the specified distribution to the null sample
4. Computing p-values based on the alternative hypothesis
}
\seealso{
\code{\link{stat_flatline_test}}, \code{\link{stat_early_conservation_test}}
}
