% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{KmerPlot}
\alias{KmerPlot}
\title{A brightness image with a different colour for each kmer.}
\usage{
KmerPlot(brightness.mat, monomer.brightness, log.trans = FALSE)
}
\arguments{
\item{brightness.mat}{The brightness matrix.}

\item{monomer.brightness}{The (median) brightness of a monomer.}

\item{log.trans}{Do you want to log-transform the colour scaling?

This is a \code{ggplot2} object and can be manipulated thus.}
}
\description{
Make a colour image based on a brightness image where each kmer has its own
colour. This requires you te specify the brightness of a monomer (which
should be greater than 1).
}
\examples{
library(EBImage)
img <- ReadImageData(system.file('extdata', '50.tif', package = 'nandb'))
display(normalize(img[, , 1]), method = 'raster')
brightness <- Brightness(img, tau = NA, mst = "Huang")
KmerPlot(brightness, 1.02)
KmerPlot(brightness, 1.12)
KmerPlot(brightness, 100)
KmerPlot(brightness, 1.02, log.trans = TRUE)
KmerPlot(MedianFilterB(brightness), 1.02)

}
