% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute-median.R
\name{scoped-impute_median}
\alias{scoped-impute_median}
\alias{impute_median_all}
\alias{impute_median_at}
\alias{impute_median_if}
\title{Scoped variants of \code{impute_median}}
\usage{
impute_median_all(.tbl)

impute_median_at(.tbl, .vars)

impute_median_if(.tbl, .predicate)
}
\arguments{
\item{.tbl}{a data.frame}

\item{.vars}{variables to impute}

\item{.predicate}{variables to impute}
}
\value{
an dataset with values imputed
}
\description{
\code{impute_median} imputes the median for a vector. To get it to work on all
variables, use \code{impute_median_all}. To only impute variables
that satisfy a specific condition, use the scoped variants,
\code{impute_below_at}, and \code{impute_below_if}. To use \code{_at} effectively,
you must know that \code{_at`` affects variables selected with a character vector, or with }vars()`.
}
\examples{
# select variables starting with a particular string.
library(dplyr)
impute_median_all(airquality)

impute_median_at(airquality,
               .vars = c("Ozone", "Solar.R"))

impute_median_at(airquality,
                .vars = vars(Ozone))

impute_median_if(airquality,
                .predicate = is.numeric)

\dontrun{
library(ggplot2)
airquality \%>\%
  bind_shadow() \%>\%
  impute_median_all() \%>\%
  add_label_shadow() \%>\%
  ggplot(aes(x = Ozone,
             y = Solar.R,
             colour = any_missing)) +
         geom_point()
}

}
