% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sha.R
\name{sha256}
\alias{sha256}
\title{Cryptographic Hashing Using the SHA-256 Algorithm}
\usage{
sha256(x, key = NULL)
}
\arguments{
\item{x}{an object.}

\item{key}{(optional) supply a secret key to generate an HMAC. If missing or
NULL, the SHA-256 hash of 'x' is returned.}
}
\value{
A 'nanoHash' object - raw vector of length 32.
}
\description{
Returns a SHA-256 hash or HMAC of the supplied R object. Uses the optimised
    implementation from the Mbed TLS library.
}
\details{
For arguments 'x' and 'key', a raw vector is hashed directly, a
    character string is converted using \code{\link{charToRaw}}, whilst other
    objects are serialised first.

    Use \code{as.character()} to convert the returned raw vector to a single
    character string.
}
\examples{
sha256("hello world!")

# Converts to a character string:
as.character(sha256("hello world!"))

# Obtain HMAC:
sha256("hello world!", "SECRET_KEY")

}
