% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nanoival.R
\docType{class}
\name{nanoival-class}
\alias{nanoival-class}
\alias{nanoival}
\alias{+,ANY,nanoival-method}
\alias{+,nanoival,ANY-method}
\alias{+,nanoival,nanoival-method}
\alias{-,ANY,nanoival-method}
\alias{-,nanoival,ANY-method}
\alias{-,nanoival,nanoival-method}
\alias{Arith,nanoival,ANY-method}
\alias{Compare,nanoival,ANY-method}
\alias{Complex,nanoival-method}
\alias{Logic,ANY,nanoival-method}
\alias{Logic,nanoival,ANY-method}
\alias{Logic,nanoival,nanoival-method}
\alias{Math2,nanoival-method}
\alias{Math,nanoival-method}
\alias{Summary,nanoival-method}
\alias{nanoival.start,nanoival-method}
\alias{nanoival.start}
\alias{nanoival.end,nanoival-method}
\alias{nanoival.end}
\alias{nanoival.sopen,nanoival-method}
\alias{nanoival.sopen}
\alias{nanoival.eopen,nanoival-method}
\alias{nanoival.eopen}
\alias{format.nanoival}
\alias{print,nanoival-method}
\alias{show,nanoival-method}
\alias{as.nanoival,character-method}
\alias{as.nanoival}
\alias{as.nanoival,NULL-method}
\alias{as.nanoival,missing-method}
\alias{is.na,nanoival-method}
\alias{is.na<-,nanoival-method}
\alias{<,nanoival,nanoival-method}
\alias{<=,nanoival,nanoival-method}
\alias{>,nanoival,nanoival-method}
\alias{>=,nanoival,nanoival-method}
\alias{==,nanoival,nanoival-method}
\alias{!=,nanoival,nanoival-method}
\alias{-,nanoival,integer64-method}
\alias{-,nanoival,numeric-method}
\alias{+,nanoival,integer64-method}
\alias{+,nanoival,numeric-method}
\alias{+,integer64,nanoival-method}
\alias{+,numeric,nanoival-method}
\alias{[[,nanoival-method}
\alias{[,nanoival,logical-method}
\alias{[,nanoival,numeric-method}
\alias{[,nanoival,character-method}
\alias{[,nanoival,ANY-method}
\alias{[<-,nanoival,logical,ANY,nanoival-method}
\alias{c.nanoival}
\alias{t,nanoival-method}
\alias{[,nanotime,nanoival-method}
\alias{NA_nanoival_}
\title{Interval type with nanosecond precision}
\format{
An object of class \code{nanoival} of length 1.
}
\usage{
nanoival(start, end, sopen = FALSE, eopen = TRUE)

\S4method{nanoival.start}{nanoival}(x)

\S4method{nanoival.end}{nanoival}(x)

\S4method{nanoival.sopen}{nanoival}(x)

\S4method{nanoival.eopen}{nanoival}(x)

\method{format}{nanoival}(x, ...)

\S4method{print}{nanoival}(x, quote = FALSE, ...)

\S4method{show}{nanoival}(object)

\S4method{as.nanoival}{character}(from, format = "", tz = "")

\S4method{as.nanoival}{`NULL`}(from, format = "", tz = "")

\S4method{as.nanoival}{missing}(from, format = "", tz = "")

\S4method{is.na}{nanoival}(x)

\S4method{is.na}{nanoival}(x) <- value

\S4method{<}{nanoival,nanoival}(e1, e2)

\S4method{<=}{nanoival,nanoival}(e1, e2)

\S4method{>}{nanoival,nanoival}(e1, e2)

\S4method{>=}{nanoival,nanoival}(e1, e2)

\S4method{==}{nanoival,nanoival}(e1, e2)

\S4method{!=}{nanoival,nanoival}(e1, e2)

\S4method{-}{nanoival,integer64}(e1, e2)

\S4method{-}{nanoival,numeric}(e1, e2)

\S4method{+}{nanoival,integer64}(e1, e2)

\S4method{+}{nanoival,numeric}(e1, e2)

\S4method{+}{integer64,nanoival}(e1, e2)

\S4method{+}{numeric,nanoival}(e1, e2)

\S4method{[[}{nanoival}(x, i, j, ..., drop = FALSE)

\S4method{[}{nanoival,logical}(x, i, j, ..., drop = FALSE)

\S4method{[}{nanoival,numeric}(x, i, j, ..., drop = FALSE)

\S4method{[}{nanoival,character}(x, i, j, ..., drop = FALSE)

\S4method{[}{nanoival,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{nanoival,logical,ANY,nanoival}(x, i, j, ...) <- value

\method{c}{nanoival}(...)

\S4method{t}{nanoival}(x)

\S4method{[}{nanotime,nanoival}(x, i, j, ..., drop = TRUE)

NA_nanoival_
}
\arguments{
\item{start}{\code{nanotime} start of interval}

\item{end}{\code{nanotime} end of interval}

\item{sopen}{logical indicating if the start of the interval is open}

\item{eopen}{logical indicating if the end of the interval is open}

\item{x, from}{a \code{nanoival} object}

\item{...}{further arguments passed to or from methods.}

\item{quote}{indicates if the output of \code{print} should be
quoted}

\item{object}{argument for method \code{show}}

\item{format}{A character string. Can also be set via
\code{options("nanotimeFormat")} and uses
\sQuote{\%Y-\%m-\%dT\%H:\%M:\%E9S\%Ez} as a default and
fallback}

\item{tz}{\code{character} indicating a timezone}

\item{value}{argument for \code{nanoival-class}}

\item{e1}{Operand of class \code{nanoival}}

\item{e2}{Operand of class \code{nanoival}}

\item{i}{index specifying elements to extract or replace.}

\item{j}{Required for \code{[} signature but ignored here}

\item{drop}{Required for \code{[} signature but ignored here}
}
\value{
A nanoival object
}
\description{
\code{nanoival} is a time interval type (an S4 class) with
nanosecond precision. One of its purposes is to allow quick
subsetting of a \code{nanotime} vector. \code{nanoival} is
composed of a \code{nanotime} pair which defines the start and end
of the time interval. Additionally, it has a pair of logical
values which determine if the start and end of the time interval
are open (true) or closed (false).
}
\details{
An interval object can be constructed with the constructor
\code{nanoival} which takes as arguments two \code{nanotime}
objects that define the start and the end of the interval,
together with two \code{logical} arguments that define if the
start and the end of the interval are open (true) or closed
(false) (note that these objects can all be vector, and therefore
the interval object is not necessarily scalar). Alternatively, an
interval can be constructed with a \code{character}: the format
follows that of \code{nanotime}; the start time is preceeded by
either \code{-} or \code{+} indicating if the interval start is
open (-) or closed (+); the start and end times are separated by
an arrow \code{->}; the end is folloed by either \code{-} or
\code{+} which have the same semantics as the start time.

The most important set of methods defined for \code{interval} are
set functions \code{intersect}, \code{union} and \code{setdiff}.

Additionally, \code{interval} allows the subsetting into a
\code{nanotime} vector. Note that subsetting is allowed only if
the \code{nanotime} vector is sorted.

Finally, accessors are provided to get the interval start
(\code{start}), the end (\code{end}), the open/close status of the
start (\code{sopen}) and the open/close status of the end
(\code{eopen}). The former return a \code{nanotime} while the
latter return a \code{logical}.
}
\section{Output Format}{


Formatting and character conversion for \code{nanoival} objects is
identical to \code{nanotime} objects. The default format is
ISO3339 compliant: \code{\%Y-\%m-\%dT\%H:\%M:\%E9S\%Ez}. It
specifies a standard ISO 8601 part for date and time --- as well
as nine digits of precision for fractional seconds (down to
nanoseconds) and on offset (typically zero as we default to UTC).
It can be overriden by using \code{options()} with the key of
\code{nanotimeFormat} and a suitable value. Similarly,
\code{nanotimeTz} can be used to select a different timezone.
}

\examples{
## creating a \code{nanoival}, with the start time included ('+') and the end
## time excluded ('-')
as.nanoival("+2012-03-01T21:21:00.000000001+00:00->2015-01-01T21:22:00.000000999+04:00-")

## a \code{nanoival} can also be created with a pair of \code{nanotime} objects, a start
## and an end, and optionally two logicals determining if the interval start(end) are open
## or closed; by default the start is closed and end is open:
start <- nanotime("2012-03-01T21:21:00.000000001+00:00")
end <- nanotime("2013-03-01T21:21:00.000000001+00:00")
nanoival(start, end)

## a vector of 'nanotime' can be subsetted by a 'nanoival':
one_second <- 1e9
a <- seq(nanotime("2012-12-12 12:12:12+00:00"), length.out=10, by=one_second)
idx <- c(as.nanoival("-2012-12-12 12:12:10+00:00 -> 2012-12-12 12:12:14+00:00-"),
         as.nanoival("+2012-12-12 12:12:18+00:00 -> 2012-12-12 12:12:20+00:00+"))
a[idx]
}
\seealso{
\code{\link{intersect.idx}}, \code{\link{setdiff.idx}},
}
\author{
Dirk Eddelbuettel

Leonardo Silvestri
}
\keyword{datasets}
