% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neg.reg.R
\name{neg.reg}
\alias{neg.reg}
\alias{equiv.reg}
\alias{When}
\alias{data}
\alias{is}
\alias{available}
\title{Test for Evaluating Negligible Effects Between a Predictor and Outcome in a Multiple Regression Model}
\usage{
neg.reg(
  data = NULL,
  formula = NULL,
  predictor = NULL,
  b = NULL,
  se = NULL,
  nop = NULL,
  n = NULL,
  eil,
  eiu,
  alpha = 0.05,
  test = "AH",
  std = FALSE,
  bootstrap = TRUE,
  nboot = 1000,
  plots = TRUE,
  saveplots = FALSE,
  seed = NA,
  ...
)
}
\arguments{
\item{data}{a data.frame or matrix which includes the variables considered in the regression model}

\item{formula}{an argument of the form y~x1+x2...xn which defines the regression model}

\item{predictor}{name of the variable/predictor upon which the test will be applied
Data not required}

\item{b}{effect size of the regression coefficient of interest, can be in standardized or unstandardized units}

\item{se}{standard error associated with the above regression coefficient effect size, pay close attention to standardized vs. unstandardized}

\item{nop}{number of predictors (excluding intercept) in the regression model}

\item{n}{the sample size used in the regression analysis
Needed for both}

\item{eil}{lower bound of the equivalence interval measured in the same units as the regression coefficients (can be either standardized or unstandardized)}

\item{eiu}{upper bound of the equivalence interval measured in the same units as the regression coefficients (can be either standardized or unstandardized)}

\item{alpha}{desired alpha level, default is .05}

\item{test}{AH is the default based on recommendation in Alter & Counsell (2020), TOST is an additional option}

\item{std}{indicate if eil and eiu along with b (when dataset is not entered) are in standardized units}

\item{bootstrap}{logical, default is TRUE, incorporating bootstrapping when calculating regression coefficients, SE, and CIs}

\item{nboot}{1000 is the default. indicate if other number of bootstrapping iterations is desired}

\item{plots}{logical, plotting the results. TRUE is set as default}

\item{saveplots}{FALSE for no, "png" and "jpeg" for different formats}

\item{seed}{to reproduce previous analyses using bootstrapping, the user can set their seed of choice}

\item{...}{additional arguments to be passed}
}
\value{
returns a \code{list} containing each analysis and their respective statistics and decision
}
\description{
This function tests whether a certain predictor variable cand be considered statistically and practically negligble according to a predefined interval (i.e., SESOI/MMES/delta) based on the Anderson-Hauck (1983) test of equivalence or Schuirmann's (1987) Two One-Sided Test (TOST)
}
\examples{
# Negligible Regression Coefficient (equivalence interval: -.1 to .1)
pr1 <- stats::rnorm(20)
pr2 <- stats::rnorm(20)
dp <- stats::rnorm(20)
dat <- data.frame(pr1,pr2,dp)
# dataset available (unstandardized coefficients, AH procedure):
neg.reg(formula=dp~pr1+pr2,data=dat,predictor=pr1,eil=-.1,eiu=.1,nboot=50)
# end
}
\author{
Udi Alter \email{udialter@yorku.ca} and
  Alyssa Counsell \email{a.counsell@ryerson.ca}
}
