% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neg_normal.R
\name{neg.normal}
\alias{neg.normal}
\alias{print.neg.normal}
\title{Negligible Effect Test for Normality of a Univariate Distribution}
\usage{
neg.normal(x, eiL = 0.95, nboot = 1000, plot = TRUE, alpha = 0.05, data = NULL)

\method{print}{neg.normal}(x, ...)
}
\arguments{
\item{x}{object of class \code{neg.normal}}

\item{eiL}{Lower Bound of the Negligible Effect Interval for W}

\item{nboot}{Number of Bootstrap Samples for computing the CIs}

\item{plot}{If the user prefers plots to be generated}

\item{alpha}{Nominal Type I Error Rate}

\item{data}{Dataset containing x}

\item{...}{Extra arguments}
}
\value{
A \code{list} including the following:
\itemize{
  \item \code{sw} Sample Shapiro-Wilk W statistic
  \item \code{sskew} Sample skewness
  \item \code{skurt} Sample kurtosis
  \item \code{sddiff_mn_mdn} Standardized difference between the sample mean and median
  \item \code{sddiff_mn_trmn} Standardized difference between the sample mean and trimmed mean
  \item \code{lb} Lower bound of 1-alpha CI for W
  \item \code{eiL} Maximum W for which the degree of nonnormality is considered extreme
}
}
\description{
This function allows researchers to test whether the distribution
of scores in a distribution has a Shapiro-Wilk W statistic that is negligibly different from 1.
}
\details{
#' This function allows researchers to test whether the distribution
of scores in a distribution has a Shapiro-Wilk W statistic that is negligibly different from 1.
I.e., we are testing the null hypothesis that W is less than or equal to some
prespecified lower bound for W (i.e., the least extreme value of W that is
non-negligibly different from 1). We recommend .95 and .975 as liberal and conservative bounds,
respectively
}
\examples{
#Normal Distribution
xx<-stats::rnorm(200)
neg.normal(xx)
#Positive Skewed Distribution
xx<-stats::rchisq(200, df=3)
neg.normal(xx)
}
\author{
Rob Cribbie \email{cribbie@yorku.ca} and
  Linda Farmus \email{lifarm@yorku.ca}
}
