% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnrm.R
\name{bnrm}
\alias{bnrm}
\title{Neo-normal model using brms}
\usage{
bnrm(
  formula,
  data,
  family = msnburr(),
  prior = NULL,
  data2 = NULL,
  sample_prior = "no",
  knots = NULL,
  drop_unused_levels = TRUE,
  stanvars = NULL,
  fit = NA,
  save_pars = getOption("brms.save_pars", NULL),
  init = NULL,
  chains = 4,
  iter = 2000,
  warmup = floor(iter/2),
  thin = 1,
  cores = getOption("mc.cores", 1),
  threads = getOption("brms.threads", NULL),
  opencl = getOption("brms.opencl", NULL),
  normalize = getOption("brms.normalize", TRUE),
  control = list(adapt_delta = 0.9),
  algorithm = getOption("brms.algorithm", "sampling"),
  backend = getOption("brms.backend", "rstan"),
  future = getOption("future", FALSE),
  silent = 1,
  seed = NA,
  save_model = NULL,
  stan_model_args = list(),
  file = NULL,
  file_compress = TRUE,
  file_refit = getOption("brms.file_refit", "never"),
  empty = FALSE,
  rename = TRUE,
  ...
)
}
\arguments{
\item{formula}{An object of class \code{\link[stats:formula]{formula}},
\code{\link[brms]{brmsformula}}, or \code{\link[brms]{mvbrmsformula}} (or one that can
be coerced to that classes): A symbolic description of the model to be
fitted. The details of model specification are explained in
\code{\link[brms]{brmsformula}}.}

\item{data}{An object of class \code{data.frame} (or one that can be coerced
to that class) containing data of all variables used in the model.}

\item{family}{the neo-normal distribution as response in  regression:msnburr(),msnburr2a(),gmsnburr(),jfst()
default argument in family is vectorize=TRUE. if not vectorize, give argument vectorize=FALSE, example:msnburr(vectorize=FALSE)}

\item{prior}{One or more \code{brmsprior} objects created by
\code{\link[brms]{set_prior}} or related functions and combined using the
\code{c} method or the \code{+} operator. See also \code{\link[brms:default_prior.default]{default_prior}}
for more help.}

\item{data2}{A named \code{list} of objects containing data, which
cannot be passed via argument \code{data}. Required for some objects
used in autocorrelation structures to specify dependency structures
as well as for within-group covariance matrices.}

\item{sample_prior}{Indicate if draws from priors should be drawn
additionally to the posterior draws. Options are \code{"no"} (the
default), \code{"yes"}, and \code{"only"}. Among others, these draws can
be used to calculate Bayes factors for point hypotheses via
\code{\link[brms]{hypothesis}}. Please note that improper priors are not sampled,
including the default improper priors used by \code{brm}. See
\code{\link[brms]{set_prior}} on how to set (proper) priors. Please also note
that prior draws for the overall intercept are not obtained by default
for technical reasons. See \code{\link[brms]{brmsformula}} how to obtain prior
draws for the intercept. If \code{sample_prior} is set to \code{"only"},
draws are drawn solely from the priors ignoring the likelihood, which
allows among others to generate draws from the prior predictive
distribution. In this case, all parameters must have proper priors.}

\item{knots}{Optional list containing user specified knot values to be used
for basis construction of smoothing terms. See
\code{\link[mgcv:gamm]{gamm}} for more details.}

\item{drop_unused_levels}{Should unused factors levels in the data be
dropped? Defaults to \code{TRUE}.}

\item{stanvars}{An optional \code{stanvars} object generated by function
\code{\link[brms]{stanvar}} to define additional variables for use in
\pkg{Stan}'s program blocks.}

\item{fit}{An instance of S3 class \code{brmsfit} derived from a previous
fit; defaults to \code{NA}. If \code{fit} is of class \code{brmsfit}, the
compiled model associated with the fitted result is re-used and all
arguments modifying the model code or data are ignored. It is not
recommended to use this argument directly, but to call the
\code{\link[brms:update.brmsfit]{update}} method, instead.}

\item{save_pars}{An object generated by \code{\link[brms]{save_pars}} controlling
which parameters should be saved in the model. The argument has no
impact on the model fitting itself.}

\item{init}{Initial values for the sampler. If \code{NULL} (the default) or
\code{"random"}, Stan will randomly generate initial values for parameters
in a reasonable range. If \code{0}, all parameters are initialized to zero
on the unconstrained space. This option is sometimes useful for certain
families, as it happens that default random initial values cause draws to
be essentially constant. Generally, setting \code{init = 0} is worth a try,
if chains do not initialize or behave well. Alternatively, \code{init} can
be a list of lists containing the initial values, or a function (or
function name) generating initial values. The latter options are mainly
implemented for internal testing but are available to users if necessary.
If specifying initial values using a list or a function then currently the
parameter names must correspond to the names used in the generated Stan
code (not the names used in \R). For more details on specifying initial
values you can consult the documentation of the selected \code{backend}.}

\item{chains}{Number of Markov chains (defaults to 4).}

\item{iter}{Number of total iterations per chain (including warmup; defaults
to 2000).}

\item{warmup}{A positive integer specifying number of warmup (aka burnin)
iterations. This also specifies the number of iterations used for stepsize
adaptation, so warmup draws should not be used for inference. The number
of warmup should not be larger than \code{iter} and the default is
\code{iter/2}.}

\item{thin}{Thinning rate. Must be a positive integer. Set \code{thin > 1} to
save memory and computation time if \code{iter} is large.}

\item{cores}{Number of cores to use when executing the chains in parallel,
which defaults to 1 but we recommend setting the \code{mc.cores} option to
be as many processors as the hardware and RAM allow (up to the number of
chains). For non-Windows OS in non-interactive \R sessions, forking is used
instead of PSOCK clusters.}

\item{threads}{Number of threads to use in within-chain parallelization. For
more control over the threading process, \code{threads} may also be a
\code{brmsthreads} object created by \code{\link[brms]{threading}}. Within-chain
parallelization is experimental! We recommend its use only if you are
experienced with Stan's \code{reduce_sum} function and have a slow running
model that cannot be sped up by any other means. Can be set globally for
the current \R session via the \code{"brms.threads"} option.}

\item{opencl}{The platform and device IDs of the OpenCL device to use for
fitting using GPU support. If you don't know the IDs of your OpenCL device,
\code{c(0,0)} is most likely what you need. For more details, see
\code{\link[brms]{opencl}}. Can be set globally for the current \R session via
the \code{"brms.opencl"} option}

\item{normalize}{Logical. Indicates whether normalization constants should
be included in the Stan code (defaults to \code{TRUE}). Setting it
to \code{FALSE} requires Stan version >= 2.25 to work. If \code{FALSE},
sampling efficiency may be increased but some post processing functions
such as \code{\link[brms]{bridge_sampler}} will not be available. Can be
controlled globally for the current \R session via the `brms.normalize`
option.}

\item{control}{A named \code{list} of parameters to control the sampler's
behavior. It defaults to \code{NULL} so all the default values are used.
The most important control parameters are discussed in the 'Details'
section below. For a comprehensive overview see
\code{\link[rstan:stan]{stan}}.}

\item{algorithm}{Character string naming the estimation approach to use.
Options are \code{"sampling"} for MCMC (the default), \code{"meanfield"} for
variational inference with independent normal distributions,
\code{"fullrank"} for variational inference with a multivariate normal
distribution, or \code{"fixed_param"} for sampling from fixed parameter
values. Can be set globally for the current \R session via the
\code{"brms.algorithm"} option .}

\item{backend}{Character string naming the package to use as the backend for
fitting the Stan model. Options are \code{"rstan"} (the default) or
\code{"cmdstanr"}. Can be set globally for the current \R session via the
\code{"brms.backend"} option . Details on the
\pkg{rstan} and \pkg{cmdstanr} packages are available at
\url{https://mc-stan.org/rstan/} and \url{https://mc-stan.org/cmdstanr/},
respectively. Additionally a \code{"mock"} backend is available to make
testing \pkg{brms} and packages that depend on it easier.
The \code{"mock"} backend does not actually do any fitting, it only checks
the generated Stan code for correctness and then returns whatever is passed
in an additional \code{mock_fit} argument as the result of the fit.}

\item{future}{Logical; If \code{TRUE}, the \pkg{\link[future:future]{future}}
package is used for parallel execution of the chains and argument
\code{cores} will be ignored. Can be set globally for the current \R
session via the \code{"future"} option. The execution type is controlled via
\code{\link[future:plan]{plan}} (see the examples section below).}

\item{silent}{Verbosity level between \code{0} and \code{2}.
If \code{1} (the default), most of the
informational messages of compiler and sampler are suppressed.
If \code{2}, even more messages are suppressed. The actual
sampling progress is still printed. Set \code{refresh = 0} to turn this off
as well. If using \code{backend = "rstan"} you can also set
\code{open_progress = FALSE} to prevent opening additional progress bars.}

\item{seed}{The seed for random number generation to make results
reproducible. If \code{NA} (the default), \pkg{Stan} will set the seed
randomly.}

\item{save_model}{Either \code{NULL} or a character string. In the latter
case, the model's Stan code is saved via \code{\link{cat}} in a text file
named after the string supplied in \code{save_model}.}

\item{stan_model_args}{A \code{list} of further arguments passed to
\code{\link[rstan:stan_model]{rstan::stan_model}} for \code{backend =
"rstan"} or to \code{cmdstanr::cmdstan_model} for \code{backend =
"cmdstanr"}, which allows to change how models are compiled.}

\item{file}{Either \code{NULL} or a character string. In the latter case, the
fitted model object is saved via \code{\link{saveRDS}} in a file named
after the string supplied in \code{file}. The \code{.rds} extension is
added automatically. If the file already exists, \code{brm} will load and
return the saved model object instead of refitting the model.
Unless you specify the \code{file_refit} argument as well, the existing
files won't be overwritten, you have to manually remove the file in order
to refit and save the model under an existing file name. The file name
is stored in the \code{brmsfit} object for later usage.}

\item{file_compress}{Logical or a character string, specifying one of the
compression algorithms supported by \code{\link{saveRDS}}. If the
\code{file} argument is provided, this compression will be used when saving
the fitted model object.}

\item{file_refit}{Modifies when the fit stored via the \code{file} argument
is re-used. Can be set globally for the current \R session via the
\code{"brms.file_refit"} option .
For \code{"never"} (default) the fit is always loaded if it
exists and fitting is skipped. For \code{"always"} the model is always
refitted. If set to \code{"on_change"}, brms will
refit the model if model, data or algorithm as passed to Stan differ from
what is stored in the file. This also covers changes in priors,
\code{sample_prior}, \code{stanvars}, covariance structure, etc. If you
believe there was a false positive, you can use
\code{\link[brms]{brmsfit_needs_refit}} to see why refit is deemed necessary.
Refit will not be triggered for changes in additional parameters of the fit
(e.g., initial values, number of iterations, control arguments, ...). A
known limitation is that a refit will be triggered if within-chain
parallelization is switched on/off.}

\item{empty}{Logical. If \code{TRUE}, the Stan model is not created
and compiled and the corresponding \code{'fit'} slot of the \code{brmsfit}
object will be empty. This is useful if you have estimated a brms-created
Stan model outside of \pkg{brms} and want to feed it back into the package.}

\item{rename}{For internal use only.}

\item{...}{Further arguments passed to Stan.
For \code{backend = "rstan"} the arguments are passed to
\code{\link[rstan]{sampling}} or \code{\link[rstan]{vb}}.
For \code{backend = "cmdstanr"} the arguments are passed to the
\code{cmdstanr::sample} or \code{cmdstanr::variational} method.}
}
\value{
An object of class \code{brmsfit}, which contains the posterior
  draws along with many other useful information about the model. Use
  \code{methods(class = "brmsfit")} for an overview on available methods.
}
\description{
Neo-normal model using brms
}
\details{
Fit a neo-normal model that using brm function in brms package.All arguments in this functions follow arguments of brm function, except family
}
\examples{
\donttest{
  library(neodistr)
  x<-runif(100)
  e<-rmsnburr(100,0,1,0.8)
  y<-0.5+0.8*x+e
  data<-data.frame(y,x)
  fit <- bnrm(
    y ~ x, data = data,
    family = msnburr())
  summary(fit)
  pp <- posterior_predict(fit)
  ppe <- posterior_epred(fit)
  loo(fit)
  }
}
\references{
Buerkner,P-C (2017). brms: An R Package for Bayesian Multilevel
Models Using Stan. \emph{Journal of Statistical Software}, 80(1), 1-28.
\code{doi:10.18637/jss.v080.i01}

Choir, A. S. (2020). The New Neo-Normal Distributions and their Properties. Disertation. Institut Teknologi Sepuluh Nopember.

Iriawan, N. (2000). Computationally Intensive Approaches to Inference in Neo-Normal Linear Models. Curtin University of Technology.
}
\author{
Achmad Syahrul Choir
}
