% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity_data_prep.R
\name{npe_longform}
\alias{npe_longform}
\title{Convert raw NEON diversity object to longform plant cover data frame}
\usage{
npe_longform(
  neon_div_object,
  trace_cover = 0.5,
  pc_na_value = 0.5,
  scale = "plot",
  verbose = FALSE,
  timescale = "annual"
)
}
\arguments{
\item{neon_div_object}{the raw diversity data downloaded using
neonPlantEcology::download_plant_div() or the function
neonUtilities::loadByProduct() with the dpID arguement set to "DP1.10058.001".}

\item{trace_cover}{cover value for subplots where only occupancy was recorded}

\item{pc_na_value}{sometimes the raw data from neon will have NA's in the percent
cover cells. This is assumed to be a data entry error and is set to 0.5 by
default.}

\item{scale}{what level of spatial aggregation? This can be "1m", "10m", "100m", "plot",
which is the default, or "site".}

\item{verbose}{if true, prints details of which eventID errors were fixed into the console}

\item{timescale}{what level of temporal aggregation? can be "subannual", which
is only important for sites with multiple sampling bouts per year,
"annual" or "all" for the full time series.}
}
\value{
a data frame with each row a single observation of species cover at the
spatial and temporal scale chosen by the user.
}
\description{
The diversity data from NEON comes as a list containing 2 data frames of data
that need to be combined, among other things. Here, we take those two data
frames and combine them into a longform data frame that can then be further
modified for analysis. Most of the unneccessary information from the raw data
has been removed. Column names that remain are plotID, subplotID, year,
taxonID, cover, scientificName, nativeStatusCode, family, and site.
}
\examples{
data("D14")
lf <- npe_longform(D14)
}
