% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_dataset.R
\name{set_dataset}
\alias{set_dataset}
\title{set Site Information for Fossil Sites}
\usage{
set_dataset(
  x = NA,
  datasetid = NA_integer_,
  database = NA_character_,
  doi = NA,
  datasettype = NA_character_,
  age_range_old = NA_integer_,
  age_range_young = NA_integer_,
  notes = NA_character_,
  pi_list = NA,
  samples = new("samples")
)
}
\arguments{
\item{x}{object to be set as dataset,}

\item{datasetid}{dataset identifier}

\item{database}{dataset where the dataset came from}

\item{doi}{DOI}

\item{datasettype}{type the dataset belongs to}

\item{age_range_old}{age range old}

\item{age_range_young}{age range young}

\item{notes}{notes}

\item{pi_list}{pi list}

\item{samples}{taxa objects}
}
\value{
\code{dataset} object
}
\description{
Function to create new \code{dataset} objects for personal analysis.
The new object will not be uploaded to the database.
}
\examples{
{
# Create a dataset
my_dataset <- set_dataset(database = "EPD",
                    datasettype = "pollen",
                    notes = "my lake")
}
}
