% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{correl_filter}
\alias{correl_filter}
\title{Correlation filter}
\usage{
correl_filter(
  y,
  x,
  force_vars = NULL,
  nfilter = NULL,
  p_cutoff = 0.05,
  method = "pearson",
  type = c("index", "names", "full"),
  ...
)
}
\arguments{
\item{y}{Response vector}

\item{x}{Matrix of predictors}

\item{force_vars}{Vector of column names within \code{x} which are always retained
in the model (i.e. not filtered). Default \code{NULL} means all predictors will
be passed to \code{filterFUN}.}

\item{nfilter}{Number of predictors to return. If \code{NULL} all predictors with
p values < \code{p_cutoff} are returned.}

\item{p_cutoff}{p value cut-off}

\item{method}{Type of correlation, either "pearson" or "spearman".}

\item{type}{Type of vector returned. Default "index" returns indices,
"names" returns predictor names, "full" returns a matrix of p-values.}

\item{...}{Further arguments passed to \link{correls}}
}
\value{
Integer vector of indices of filtered parameters (type = "index") or
character vector of names (type = "names") of filtered parameters. If
\code{type} is \code{"full"} full output from \link{correls} is returned.
}
\description{
Filter using correlation (Pearson or Spearman) for ranking variables.
}
