% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/exportToTSPlibFormat.R
\name{exportToTSPlibFormat}
\alias{exportToTSPlibFormat}
\title{Exports a network to the TSPlib format.}
\usage{
exportToTSPlibFormat(x, filename, name = NULL, comment = NULL,
  use.extended.format = TRUE, digits = 2L)
}
\arguments{
\item{x}{[\code{Network}]\cr
Network to export.}

\item{filename}{[\code{character(1)}]\cr
File name.}

\item{name}{[\code{character(1)} | \code{NULL}]\cr
Character string describing the instance. Used for the NAME field in the
TSPlib file format. Otherwise, the name of the instance is used. If the
latter is \code{NULL}, this parameter is mandatory.}

\item{comment}{[\code{character(1)} | \code{NULL}]\cr
Optional string with additional information about the instance. Used for
the COMMENT field. If not provided the comment field of the instance is
used. If the latter is \code{NULL}, no comment at all is saved.}

\item{use.extended.format}{[\code{logical(1)}]\cr
Use the \dQuote{extended tsplib format} with additional information like cluster
membership and bounds? Default is \code{TRUE}.}

\item{digits}{[\code{integer(1)}]\cr
Round coordinates to this number of digits. Default is 2.}
}
\value{
Nothing
}
\description{
Exports a network to the TSPlib format.
}
\note{
Currently we only support euclidean 2D instances. Furthermore note, that
if \code{use.extended.format} is \code{TRUE}, most alternative TSPlib parsers
will most probably not be able to parse the generated file.
}

