% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netdistance.R
\name{netdistance.default}
\alias{netdistance.default}
\alias{netdistance}
\alias{netdistance.netmeta}
\alias{netdistance.netcomb}
\alias{print.netdistance}
\alias{netdistance.netconnection}
\title{Calculate distance matrix for an adjacency matrix}
\usage{
\method{netdistance}{default}(x, ...)

\method{netdistance}{netmeta}(x, sort = gs("sort.distance"), ...)

\method{netdistance}{netcomb}(x, sort = gs("sort.distance"), ...)

\method{netdistance}{netconnection}(x, ...)

\method{print}{netdistance}(x, lab.Inf = ".", ...)

netdistance(x, ...)
}
\arguments{
\item{x}{Either a netmeta or netcomb object or an adjacency matrix.}

\item{\dots}{Additional arguments.}

\item{sort}{A logical indicating whether to sort within (sub)networks by
treatment names.}

\item{lab.Inf}{A character string to label infinite values.}
}
\description{
Calculate distance matrix for an adjacency matrix based on distance
algorithm by Müller et al. (1987).
}
\examples{
data(smokingcessation)

pw1 <- pairwise(list(treat1, treat2, treat3),
  event = list(event1, event2, event3), n = list(n1, n2, n3),
  data = smokingcessation, sm = "OR")
net1 <- netmeta(pw1, common = FALSE)

netdistance(net1)

\donttest{
data(Senn2013)

net1 <- netmeta(TE, seTE, treat1, treat2, studlab,
  data = Senn2013, sm = "MD")

netdistance(net1)
netdistance(net1$A.matrix)
}

}
\references{
Müller WR, Szymanski K, Knop JV, and Trinajstic N (1987):
An algorithm for construction of the molecular distance matrix.
\emph{Journal of Computational Chemistry},
\bold{8}, 170--73
}
\seealso{
\code{\link{netmeta}}, \code{\link{netconnection}}
}
\author{
Gerta Rücker \email{gerta.ruecker@uniklinik-freiburg.de}
  Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
