% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighborhood.inclusion.R
\name{neighborhood_inclusion}
\alias{neighborhood_inclusion}
\title{Neighborhood-inclusion preorder}
\usage{
neighborhood_inclusion(g)
}
\arguments{
\item{g}{An igraph object}
}
\value{
The neighborhood-inclusion preorder of \code{g} as matrix object. \code{P[u,v]=1} if \eqn{N(u)\subseteq N[v]}
}
\description{
Calculates the neighborhood-inclusion preorder of an undirected graph.
}
\details{
Neighborhood-inclusion is defined as
\deqn{N(u)\subseteq N[v]}
where \eqn{N(u)} is the neighborhood of \eqn{u} and \eqn{N[v]=N(v)\cup \lbrace v\rbrace} is the closed neighborhood of \eqn{v}.
\eqn{N(u) \subseteq N[v]} implies that \eqn{c(u) \leq c(v)},
where \eqn{c} is a centrality index based on a specific path algebra. Indices
falling into this category are closeness (and variants), betweenness
(and variants) as well as many walk-based indices (eigenvector and subgraph
centrality, total communicability,...).
}
\examples{
library(igraph)
# the neighborhood inclusion preorder of a star graph is complete
g <- graph.star(5,'undirected')
P <- neighborhood_inclusion(g)
comparable_pairs(P)

# the same holds for threshold graphs
tg <- threshold_graph(50,0.1)
P <- neighborhood_inclusion(tg)
comparable_pairs(P)

# standard centrality indices preserve neighborhood-inclusion
data("dbces11")
P <- neighborhood_inclusion(dbces11)

is_preserved(P,degree(dbces11))
is_preserved(P,closeness(dbces11))
is_preserved(P,betweenness(dbces11))
}
\references{
Schoch, D. and Brandes, U., 2016. Re-conceptualizing centrality in social networks.
\emph{European Journal of Applied Mathematics} 27(6), 971-985.

Brandes, U. Heine, M., Müller, J. and Ortmann, M., 2017.
Positional Dominance: Concepts and Algorithms.
\emph{Conference on Algorithms and Discrete Applied Mathematics}, 60-71.
}
\seealso{
\link{positional_dominance}, \link{exact_rank_prob}
}
\author{
David Schoch
}
