% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold.graph.R
\name{threshold_graph}
\alias{threshold_graph}
\title{Random threshold graphs}
\usage{
threshold_graph(n, p, bseq)
}
\arguments{
\item{n}{The number of vertices in the graph.}

\item{p}{The probability of inserting dominating vertices. Equates approximately
to the density of the graph. See Details.}

\item{bseq}{(0,1)-vector a binary sequence that produces a threshold grah. See details}
}
\value{
A threshold graph as igraph object
}
\description{
Constructs a random threshold graph.
A threshold graph is a graph where the neighborhood inclusion preorder is complete.
}
\details{
Either \code{n} and \code{p}, or \code{bseq} must be specified.
Threshold graphs can be constructed with a binary sequence. For each 0, an isolated
vertex is inserted and for each 1, a vertex is inserted that connects to all previously inserted
vertices. The probability of inserting a dominating vertices is controlled with parameter \code{p}.
If \code{bseq} is given instead, a threshold graph is constructed from that sequence.
An important property of threshold graphs is, that all centrality indices induce the same ranking.
}
\examples{
library(igraph)
g <- threshold_graph(10,0.3)
\dontrun{
plot(g)

# star graphs and complete graphs are threshold graphs
complete <- threshold_graph(10,1) #complete graph
plot(complete)

star <- threshold_graph(10,0) #star graph
plot(star)
}

# centrality scores are perfectly rank correlated
cor(degree(g),closeness(g),method = "kendall")
}
\references{
Mahadev, N. and Peled, U. N. , 1995. Threshold graphs and related topics.

Schoch, D., Valente, T. W. and Brandes, U., 2017. Correlations among centrality
indices and a class of uniquely ranked graphs. \emph{Social Networks} 50, 46–54.
}
\seealso{
\link{neighborhood_inclusion}, \link{positional_dominance}
}
\author{
David Schoch
}
