% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localClusteringCoefficient.R
\name{localClusteringCoefficient}
\alias{localClusteringCoefficient}
\title{Calculate the local clustering coefficient}
\usage{
localClusteringCoefficient(adj)
}
\arguments{
\item{adj}{An adjacency matrix. Calculating the clustering coefficient only makes sense if some connections are zero i.e. no connection.}
}
\value{
A vector of local clustering coefficients for each node/gene of the adjacency matrix.
}
\description{
Calculate the local clustering coefficient for each node in an adjacency matrix. The clustering coefficient is defined as the proportion of existing connections from the total possible (Watts and Strogatz, 1998).
}
\examples{

localClusteringCoefficient(network_gen(50,.33)$network)
}
\references{
D.J. Watts and S.H. Strogatz. (1998) Collective dynamics of 'small-world' networks. Nature. 393(6684). 440-442.
}
\seealso{
\link{clusteringCoefficient}
}
\author{
Nathan S. Watson-Haigh
}
