# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Construct family id vector from pedigree trio information
#'
#' @description Create a vector of length n, giving the family id of
#' each subject.  If the pedigree is totally connected, then everyone
#' will end up in tree 1, otherwise the tree numbers represent the
#' disconnected subfamilies.  Singleton subjects each have unique
#' family numbers.
#'
#' No check is done to ensure that the id, fid, and mid actually refer to proper family structure.
#' References to ids in the fid and mid arguments that are not part of the id vector are considered founders and are thus replaced by NA or 0s after being used to group full and half-sibs.
#' @param id Numeric vector of ids
#' @param fid Numeric vector of ids of the father. This should be NA or 0 for a founder.
#' @param mid Numeric vector of ids of the mother. This should be NA or 0 for a founder.
#' @return Returns an integer vector giving the family index of each individual
#' @author Claus Ekstrom \email{ekstrom@@sund.ku.dk}
#' @keywords manip
#' @examples
#'
#' id <- 1:11
#' fid <- c(NA, NA, 1, 1, NA, 23, 45, 5, 5, 7, NA)
#' mid <- c(NA, NA, 2, 2, 65, NA, 46, 6, 6, 6, 0)
#' make_family_id(id, fid, mid)
#'
#' @export 
make_family_id <- function(id, fid, mid) {
    .Call('_networkR_make_family_id', PACKAGE = 'networkR', id, fid, mid)
}

#' Construct parental chain id vector from pedigree trio information
#'
#' @description Create a vector of length n, giving the id of
#' parental chains.  If the pedigree is totally connected, then everyone
#' will end up in tree 1, otherwise the tree numbers represent the
#' disconnected subfamilies.  Singleton subjects each have unique
#' family numbers.
#'
#' No check is done to ensure that the id, fid, and mid actually refer to proper family structure.
#' References to ids in the fid and mid arguments that are not part of the id vector are considered founders.
#' @param id Numeric vector of ids
#' @param fid Numeric vector of ids of the father. This should be NA or 0 for a founder.
#' @param mid Numeric vector of ids of the mother. This should be NA or 0 for a founder.
#' @return Returns an integer vector giving the family index
#' @author Claus Ekstrom \email{ekstrom@@sund.ku.dk}
#' @keywords manip
#' @examples
#'
#' id <- 1:11
#' fid <- c(0,0,1,0,0,4,0,0,3,7,7)
#' mid <- c(0,0,2,0,0,5,0,0,6,6,8)
#' make_parental_chain(id, fid, mid)
#'
#' @importFrom Rcpp evalCpp
#' @export 
make_parental_chain <- function(id, fid, mid) {
    .Call('_networkR_make_parental_chain', PACKAGE = 'networkR', id, fid, mid)
}

