% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.neuralGAM.R
\name{autoplot.neuralGAM}
\alias{autoplot.neuralGAM}
\title{Advanced \code{neuralGAM} visualization with ggplot2 library}
\usage{
\method{autoplot}{neuralGAM}(object, select, xlab = NULL, ylab = NULL, ...)
}
\arguments{
\item{object}{a fitted \code{neuralGAM} object as produced by \code{neuralGAM()}.}

\item{select}{selects the term to be plotted.}

\item{xlab}{A title for the \code{x} axis.}

\item{ylab}{A title for the \code{y} axis.}

\item{\ldots}{other graphics parameters to pass on to plotting commands.
See details for ggplot2::geom_line options}
}
\value{
A ggplot object, so you can use common features from the ggplot2 package
to manipulate the plot.
}
\description{
Advanced \code{neuralGAM} visualization with ggplot2 library
}
\examples{
\donttest{
n <- 24500

seed <- 42
set.seed(seed)

x1 <- runif(n, -2.5, 2.5)
x2 <- runif(n, -2.5, 2.5)
x3 <- runif(n, -2.5, 2.5)

f1 <- x1 ** 2
f2 <- 2 * x2
f3 <- sin(x3)
f1 <- f1 - mean(f1)
f2 <- f2 - mean(f2)
f3 <- f3 - mean(f3)

eta0 <- 2 + f1 + f2 + f3
epsilon <- rnorm(n, 0.25)
y <- eta0 + epsilon
train <- data.frame(x1, x2, x3, y)

library(neuralGAM)
ngam <- neuralGAM(y ~ s(x1) + x2 + s(x3), data = train,
                 num_units = 1024, family = "gaussian",
                 activation = "relu",
                 learning_rate = 0.001, bf_threshold = 0.001,
                 max_iter_backfitting = 10, max_iter_ls = 10,
                 seed = seed
                 )
autoplot(ngam, select="x1")

# add custom title
autoplot(ngam, select="x1") + ggplot2::ggtitle("Main Title")
# add labels
autoplot(ngam, select="x1") + ggplot2::xlab("test") + ggplot2::ylab("my y lab")
# plot multiple terms:
plots <- lapply(c("x1", "x2", "x3"), function(x) autoplot(ngam, select = x))
gridExtra::grid.arrange(grobs = plots, ncol = 3, nrow = 1)
}
}
\author{
Ines Ortega-Fernandez, Marta Sestelo.
}
